/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.cost.Cost;
import su.nightexpress.excellentcrates.crate.cost.CostDialogs;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.dialog.DialogRegistry;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CostsListMenu
extends LinkedMenu<CratesPlugin, Crate>
implements LangContainer {
    private static final int[] COST_SLOTS = new int[]{19, 20, 21, 22, 23, 24, 25};
    private static final int[] TOGGLE_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16};
    private static final int[] STATUS_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34};
    private static final IconLocale LOCALE_DATA_VACANT = LangEntry.iconBuilder((String)"Editor.Costs.Data.Vacant").accentColor((TagWrapper)TagWrappers.SOFT_AQUA).name("Vacant Slot").appendInfo(new String[]{"Add an cost option for your crate!"}).br().appendClick("Click to create").build();
    private static final IconLocale LOCALE_DATA_FILLED = LangEntry.iconBuilder((String)"Editor.Costs.Data.Filled").rawName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Cost Option: ") + TagWrappers.WHITE.wrap("%cost_name%") + " " + TagWrappers.GRAY.wrap("(ID: " + TagWrappers.WHITE.wrap("%cost_id%") + ")")).rawLore(new String[]{TagWrappers.ITALIC.and((TagWrapper)TagWrappers.DARK_GRAY).wrap("Press " + TagWrappers.SOFT_RED.wrap((String)TagWrappers.KEY.apply("key.drop")) + " key to delete.")}).br().rawLore(new String[]{"%costs%"}).br().appendClick("Click to edit", (TagWrapper)TagWrappers.YELLOW).build();
    private static final IconLocale LOCALE_DATA_EMPTY = LangEntry.iconBuilder((String)"Editor.Costs.Data.Empty").rawName(TagWrappers.RED.and((TagWrapper)TagWrappers.BOLD).wrap("Cost Option: ") + TagWrappers.WHITE.wrap("%cost_name%") + " " + TagWrappers.GRAY.wrap("(ID: " + TagWrappers.WHITE.wrap("%cost_id%") + ")")).rawLore(new String[]{TagWrappers.ITALIC.and((TagWrapper)TagWrappers.DARK_GRAY).wrap("Press " + TagWrappers.SOFT_RED.wrap((String)TagWrappers.KEY.apply("key.drop")) + " key to delete.")}).br().rawLore(new String[]{TagWrappers.SOFT_RED.wrap("No costs defined!")}).br().appendClick("Click to edit", (TagWrapper)TagWrappers.RED).build();
    private static final IconLocale LOCALE_TOGGLE_ENABLED = LangEntry.iconBuilder((String)"Editor.Costs.Toggle.Enabled").accentColor((TagWrapper)TagWrappers.GREEN).name("Enabled").appendClick("Click to toggle").build();
    private static final IconLocale LOCALE_TOGGLE_DISABLED = LangEntry.iconBuilder((String)"Editor.Costs.Toggle.Disabled").accentColor((TagWrapper)TagWrappers.WHITE).name("Disabled").appendClick("Click to toggle").build();
    private static final IconLocale LOCALE_TOGGLE_NOTHING = LangEntry.iconBuilder((String)"Editor.Costs.Toggle.Nothing").rawName(TagWrappers.GRAY.wrap("< No Data >")).build();
    private static final IconLocale LOCALE_STATUS_GOOD = LangEntry.iconBuilder((String)"Editor.Costs.Status.Good").rawName(TagWrappers.GREEN.and((TagWrapper)TagWrappers.BOLD).wrap("Status: ") + TagWrappers.WHITE.wrap("Good")).appendInfo(new String[]{"All entries are valid!"}).build();
    private static final IconLocale LOCALE_STATUS_WARN = LangEntry.iconBuilder((String)"Editor.Costs.Status.Warn").rawName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Status: ") + TagWrappers.WHITE.wrap("Warning")).appendInfo(new String[]{"Some entries are invalid!"}).build();
    private static final IconLocale LOCALE_STATUS_BAD = LangEntry.iconBuilder((String)"Editor.Costs.Status.Bad").rawName(TagWrappers.RED.and((TagWrapper)TagWrappers.BOLD).wrap("Status: ") + TagWrappers.WHITE.wrap("Invalid")).appendInfo(new String[]{"No valid entries!"}).build();
    private static final IconLocale LOCALE_STATUS_NOTHING = LangEntry.iconBuilder((String)"Editor.Costs.Status.Nothing").rawName(TagWrappers.GRAY.and((TagWrapper)TagWrappers.BOLD).wrap("Status: ") + TagWrappers.WHITE.wrap("< No Data>")).build();
    private final DialogRegistry dialogs;

    public CostsListMenu(@NotNull CratesPlugin plugin, @NotNull DialogRegistry dialogs) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X6, Lang.EDITOR_TITLE_CRATE_COSTS.text());
        this.dialogs = dialogs;
        ((CratesPlugin)this.plugin).injectLang(this);
        this.addItem(MenuItem.buildReturn((Menu)this, (int)49, (viewer, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openOptionsMenu(viewer.getPlayer(), (Crate)this.getLink(viewer)))));
        this.addItem(NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setPriority(-1).setSlots(new int[]{45, 46, 52, 53}));
        this.addItem(NightItem.fromType((Material)Material.GRAY_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setPriority(-1).setSlots(new int[]{47, 48, 49, 50, 51}));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player player = viewer.getPlayer();
        Crate crate = (Crate)this.getLink(player);
        List<Cost> costs = crate.getCosts();
        for (int index = 0; index < COST_SLOTS.length; ++index) {
            MenuItem.Builder statusBuilder;
            MenuItem.Builder entryBuilder;
            MenuItem.Builder toggleBuilder;
            int slot = COST_SLOTS[index];
            int toggleSlot = TOGGLE_SLOTS[index];
            int statusSlot = STATUS_SLOTS[index];
            if (index < costs.size()) {
                Cost cost = costs.get(index);
                boolean isValid = cost.isValid();
                boolean hasInvalids = cost.hasInvalids();
                toggleBuilder = NightItem.fromType((Material)(cost.isEnabled() ? Material.LIME_DYE : Material.GRAY_DYE)).localized(cost.isEnabled() ? LOCALE_TOGGLE_ENABLED : LOCALE_TOGGLE_DISABLED).toMenuItem().setHandler((viewer1, event) -> {
                    cost.setEnabled(!cost.isEnabled());
                    crate.markDirty();
                    this.runNextTick(() -> this.flush(viewer));
                });
                entryBuilder = NightItem.fromItemStack((ItemStack)cost.getIconStack()).localized(cost.isEmpty() ? LOCALE_DATA_EMPTY : LOCALE_DATA_FILLED).replacement(replacer -> replacer.replace(cost.replacePlaceholders()).replace("%costs%", () -> cost.getEntries().stream().map(entry -> entry.isValid() ? CoreLang.goodEntry((String)entry.format()) : CoreLang.badEntry((String)entry.format())).collect(Collectors.joining(TagWrappers.BR)))).hideAllComponents().toMenuItem().setHandler((viewer1, event) -> {
                    if (event.getClick() == ClickType.DROP) {
                        crate.removeCost(cost);
                        crate.markDirty();
                        this.runNextTick(() -> this.flush(viewer));
                        return;
                    }
                    this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openCostOptions(player, crate, cost));
                });
                statusBuilder = NightItem.fromType((Material)(!isValid ? Material.RED_STAINED_GLASS_PANE : (hasInvalids ? Material.YELLOW_STAINED_GLASS_PANE : Material.LIME_STAINED_GLASS_PANE))).localized(!isValid ? LOCALE_STATUS_BAD : (hasInvalids ? LOCALE_STATUS_WARN : LOCALE_STATUS_GOOD)).toMenuItem();
            } else {
                toggleBuilder = NightItem.fromType((Material)Material.GRAY_DYE).localized(LOCALE_TOGGLE_NOTHING).toMenuItem();
                statusBuilder = NightItem.fromType((Material)Material.GRAY_STAINED_GLASS_PANE).localized(LOCALE_STATUS_NOTHING).toMenuItem();
                entryBuilder = NightItem.fromType((Material)Material.STRUCTURE_VOID).localized(LOCALE_DATA_VACANT).hideAllComponents().toMenuItem().setHandler((viewer1, event) -> this.dialogs.show(player, CostDialogs.CREATION, crate, () -> this.flush(player)));
            }
            viewer.addItem(entryBuilder.setSlots(new int[]{slot}).setPriority(Integer.MAX_VALUE).build());
            viewer.addItem(toggleBuilder.setSlots(new int[]{toggleSlot}).setPriority(Integer.MAX_VALUE).build());
            viewer.addItem(statusBuilder.setSlots(new int[]{statusSlot}).setPriority(Integer.MAX_VALUE).build());
        }
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }
}

