/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.crate.cost.Cost;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.reward.impl.ItemReward;
import su.nightexpress.excellentcrates.dialog.DialogRegistry;
import su.nightexpress.excellentcrates.editor.EditorMenu;
import su.nightexpress.excellentcrates.editor.crate.CostOptionsMenu;
import su.nightexpress.excellentcrates.editor.crate.CostsListMenu;
import su.nightexpress.excellentcrates.editor.crate.CrateListMenu;
import su.nightexpress.excellentcrates.editor.crate.CrateMilestonesMenu;
import su.nightexpress.excellentcrates.editor.crate.CrateOptionsMenu;
import su.nightexpress.excellentcrates.editor.crate.RewardContentMenu;
import su.nightexpress.excellentcrates.editor.crate.RewardListMenu;
import su.nightexpress.excellentcrates.editor.crate.RewardOptionsMenu;
import su.nightexpress.excellentcrates.editor.key.KeyListMenu;
import su.nightexpress.excellentcrates.editor.key.KeyOptionsMenu;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractManager;

public class EditorManager
extends AbstractManager<CratesPlugin> {
    private final DialogRegistry dialogs;
    private EditorMenu editorMenu;
    private CrateListMenu crateListMenu;
    private CrateOptionsMenu crateOptionsMenu;
    private CostsListMenu costsListMenu;
    private CostOptionsMenu costOptionsMenu;
    private CrateMilestonesMenu crateMilestonesMenu;
    private RewardListMenu rewardListMenu;
    private RewardOptionsMenu rewardOptionsMenu;
    private RewardContentMenu rewardContentMenu;
    private KeyListMenu keyListMenu;
    private KeyOptionsMenu keyOptionsMenu;

    public EditorManager(@NotNull CratesPlugin plugin, @NotNull DialogRegistry dialogs) {
        super((NightCorePlugin)plugin);
        this.dialogs = dialogs;
    }

    protected void onLoad() {
        this.editorMenu = new EditorMenu((CratesPlugin)this.plugin);
        this.crateListMenu = new CrateListMenu((CratesPlugin)this.plugin, this.dialogs);
        this.crateOptionsMenu = new CrateOptionsMenu((CratesPlugin)this.plugin, this.dialogs);
        this.costsListMenu = new CostsListMenu((CratesPlugin)this.plugin, this.dialogs);
        this.costOptionsMenu = new CostOptionsMenu((CratesPlugin)this.plugin, this.dialogs);
        this.crateMilestonesMenu = new CrateMilestonesMenu((CratesPlugin)this.plugin);
        this.rewardListMenu = new RewardListMenu((CratesPlugin)this.plugin, this.dialogs);
        this.rewardOptionsMenu = new RewardOptionsMenu((CratesPlugin)this.plugin, this.dialogs);
        this.rewardContentMenu = new RewardContentMenu((CratesPlugin)this.plugin, this.dialogs);
        this.keyListMenu = new KeyListMenu((CratesPlugin)this.plugin, this.dialogs);
        this.keyOptionsMenu = new KeyOptionsMenu((CratesPlugin)this.plugin, this.dialogs);
    }

    protected void onShutdown() {
        if (this.crateListMenu != null) {
            this.crateListMenu.clear();
        }
        if (this.crateOptionsMenu != null) {
            this.crateOptionsMenu.clear();
        }
        if (this.costsListMenu != null) {
            this.costsListMenu.clear();
        }
        if (this.costOptionsMenu != null) {
            this.costOptionsMenu.clear();
        }
        if (this.crateMilestonesMenu != null) {
            this.crateMilestonesMenu.clear();
        }
        if (this.rewardListMenu != null) {
            this.rewardListMenu.clear();
        }
        if (this.rewardOptionsMenu != null) {
            this.rewardOptionsMenu.clear();
        }
        if (this.rewardContentMenu != null) {
            this.rewardContentMenu.clear();
        }
        if (this.keyListMenu != null) {
            this.keyListMenu.clear();
        }
        if (this.keyOptionsMenu != null) {
            this.keyOptionsMenu.clear();
        }
        if (this.editorMenu != null) {
            this.editorMenu.clear();
        }
    }

    public void openEditor(@NotNull Player player) {
        this.editorMenu.open(player);
    }

    public void openCrateList(@NotNull Player player) {
        this.crateListMenu.open(player, (Object)((CratesPlugin)this.plugin).getCrateManager());
    }

    public void openOptionsMenu(@NotNull Player player, @NotNull Crate crate) {
        this.crateOptionsMenu.open(player, crate);
    }

    public void openCosts(@NotNull Player player, @NotNull Crate crate) {
        this.costsListMenu.open(player, crate);
    }

    public void openCostOptions(@NotNull Player player, @NotNull Crate crate, @NotNull Cost cost) {
        this.costOptionsMenu.open(player, crate, cost);
    }

    public void openMilestones(@NotNull Player player, @NotNull Crate crate) {
        this.crateMilestonesMenu.open(player, crate);
    }

    public void openRewardList(@NotNull Player player, @NotNull Crate crate) {
        this.rewardListMenu.open(player, crate);
    }

    public void openRewardContent(@NotNull Player player, @NotNull ItemReward reward) {
        this.rewardContentMenu.open(player, reward);
    }

    public void openRewardOptions(@NotNull Player player, @NotNull Reward reward) {
        this.rewardOptionsMenu.open(player, reward);
    }

    public void openKeyList(@NotNull Player player) {
        this.keyListMenu.open(player, (Object)((CratesPlugin)this.plugin).getKeyManager());
    }

    public void openKeyOptions(@NotNull Player player, @NotNull CrateKey key) {
        this.keyOptionsMenu.open(player, key);
    }
}

