/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.reward;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.crate.impl.Rarity;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardWeightDialog
extends Dialog<Reward> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Reward.Weight.Title").text(RewardWeightDialog.title("Reward", "Weight & Rariry"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Reward.Weight.Body").dialogElement(400, new String[]{"Set the desired " + TagWrappers.SOFT_YELLOW.wrap("rarity") + " and " + TagWrappers.SOFT_YELLOW.wrap("weight") + " for the reward.", "", "You can learn more about how rarity and weight work " + ((SimpleTagWrapper)TagWrappers.OPEN_URL.with("https://nightexpressdev.com/excellentcrates/rewards/rarity-weights/")).wrap(TagWrappers.SOFT_GREEN.and((TagWrapper)TagWrappers.UNDERLINED).wrap("HERE")) + "."});
    private static final TextLocale INTPUT_RARITY = LangEntry.builder((String)"Dialog.Reward.Weight.Input.Rarity").text(TagWrappers.SOFT_YELLOW.wrap("Rarity"));
    private static final TextLocale INTPUT_WEIGHT = LangEntry.builder((String)"Dialog.Reward.Weight.Input.Weight").text(TagWrappers.SOFT_YELLOW.wrap("Weight"));
    private static final String JSON_WEIGHT = "weight";
    private static final String JSON_RARITY = "rarity";
    private final CratesPlugin plugin;

    public RewardWeightDialog(@NotNull CratesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Reward reward) {
        ArrayList rarities = new ArrayList();
        this.plugin.getCrateManager().getRarities().forEach(rarity -> rarities.add(new WrappedSingleOptionEntry(rarity.getId(), rarity.getName(), reward.getRarity() == rarity)));
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.singleOption((String)JSON_RARITY, (TextLocale)INTPUT_RARITY, (List)rarities).build(), DialogInputs.text((String)JSON_WEIGHT, (TextLocale)INTPUT_WEIGHT).initial(String.valueOf(reward.getWeight())).maxLength(6).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                Rarity rarity = nbtHolder.getText(JSON_RARITY).map(id -> this.plugin.getCrateManager().getRarity((String)id)).orElse(reward.getRarity());
                double weight = nbtHolder.getDouble(JSON_WEIGHT, reward.getWeight());
                reward.setRarity(rarity);
                reward.setWeight(weight);
                viewer.callback();
            });
        });
    }
}

