/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.reward;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Keyed;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.nightcore.bridge.common.NightNbtHolder;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.ButtonLocale;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.EnumLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogActions;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardSortingDialog
extends Dialog<Crate> {
    private static final EnumLocale<SortMode> SORT_MODE_LOCALE = LangEntry.builder((String)"Dialog.Rewards.Sorting.Mode").enumeration(SortMode.class);
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Rewards.Sorting.Title").text(RewardSortingDialog.title("Rewards", "Sorting"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Rewards.Sorting.Body").dialogElement(400, new String[]{"Please select a sorting mode."});
    public static final TextLocale INPUT_REVERSED = LangEntry.builder((String)"Dialog.Rewards.Sorting.Input.Reversed").text("Reversed");
    private static final ButtonLocale BUTTON_MODE = LangEntry.builder((String)"Dialog.Rewards.Sorting.Button.Mode").button(TagWrappers.SOFT_YELLOW.wrap("\u2192") + " Mode: " + TagWrappers.SOFT_YELLOW.wrap("%s"));
    private static final String JSON_REVERSED = "reversed";
    private static final String JSON_MODE = "mode";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Crate crate) {
        ArrayList<WrappedActionButton> buttons = new ArrayList<WrappedActionButton>();
        for (SortMode mode : SortMode.values()) {
            buttons.add(DialogButtons.action((ButtonLocale)BUTTON_MODE.replace(str -> str.formatted(SORT_MODE_LOCALE.getLocalized((Enum)mode)))).action((WrappedDialogAction)DialogActions.customClick((String)"ok", (NightNbtHolder)NightNbtHolder.builder().put(JSON_MODE, LowerCase.INTERNAL.apply(mode.name())).build())).build());
        }
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).inputs(new WrappedDialogInput[]{DialogInputs.bool((String)JSON_REVERSED, (TextLocale)INPUT_REVERSED).initial(false).build()}).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((List)buttons).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String raw = nbtHolder.getText(JSON_MODE).orElse(null);
                if (raw == null) {
                    return;
                }
                SortMode mode = (SortMode)Enums.get((String)raw, SortMode.class);
                if (mode == null) {
                    return;
                }
                boolean reversed = nbtHolder.getBoolean(JSON_REVERSED, false);
                Comparator<Reward> comparator = mode.getComparator(reversed);
                crate.setRewards(crate.getRewards().stream().sorted(comparator).toList());
                crate.markDirty();
                viewer.closeFully();
            });
        });
    }

    private static enum SortMode {
        WEIGHT(Comparator.comparingDouble(Reward::getWeight)),
        RARITY(Comparator.comparingDouble(reward -> reward.getRarity().getWeight())),
        CHANCE(Comparator.comparingDouble(Reward::getRollChance)),
        NAME(Comparator.comparing(reward -> NightMessage.stripTags((String)reward.getName()))),
        ITEM(Comparator.comparing(reward -> BukkitThing.getValue((Keyed)reward.getPreviewItem().getType())));

        private final Comparator<Reward> comparator;

        private SortMode(Comparator<Reward> comparator) {
            this.comparator = comparator;
        }

        @NotNull
        public Comparator<Reward> getComparator(boolean reversed) {
            return reversed ? this.comparator.reversed() : this.comparator;
        }
    }
}

