/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.reward;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.text.WrappedMultilineOptions;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardPermissionsDialog
extends Dialog<Reward> {
    private static final String NEGATIVE = "-";
    private static final String POSITIVE = "+";
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Reward.Permissions.Title").text(RewardPermissionsDialog.title("Reward", "Permissions"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Reward.Permissions.Body").dialogElement(400, new String[]{"Specify the permissions a player must have or must not have to access this reward.", "", "Use the " + TagWrappers.GREEN.and((TagWrapper)TagWrappers.BOLD).wrap("+") + " prefix to list permissions the player " + TagWrappers.GREEN.wrap("must have") + ", and the " + TagWrappers.RED.and((TagWrapper)TagWrappers.BOLD).wrap("-") + " prefix for permissions the player " + TagWrappers.RED.wrap("must not have") + ".", "", "Player must have any of the " + TagWrappers.GREEN.wrap("'positive'") + " permissions and none of the " + TagWrappers.RED.wrap("'negative'") + " ones."});
    private static final TextLocale INPUT_PERMISSIONS = LangEntry.builder((String)"Dialog.Reward.Permissions.Input.Permissions").text("Permissions");
    private static final String JSON_PERMISSIONS = "permissions";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Reward reward) {
        ArrayList initial = new ArrayList();
        reward.getRequiredPermissions().forEach(perm -> initial.add(POSITIVE + perm));
        reward.getIgnoredPermissions().forEach(perm -> initial.add(NEGATIVE + perm));
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_PERMISSIONS, (TextLocale)INPUT_PERMISSIONS).maxLength(300).width(300).initial(String.join((CharSequence)"\n", initial)).multiline(new WrappedMultilineOptions(Integer.valueOf(10), Integer.valueOf(150))).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                List permissions = nbtHolder.getText(JSON_PERMISSIONS).map(raw -> raw.isBlank() ? new ArrayList() : List.of(raw.split("\n"))).orElse(null);
                if (permissions == null) {
                    return;
                }
                HashSet<String> negative = new HashSet<String>();
                HashSet<String> positive = new HashSet<String>();
                permissions.forEach(perm -> {
                    if (perm.startsWith(POSITIVE)) {
                        positive.add(perm.substring(1));
                    } else if (perm.startsWith(NEGATIVE)) {
                        negative.add(perm.substring(1));
                    } else {
                        positive.add((String)perm);
                    }
                });
                reward.setIgnoredPermissions(negative);
                reward.setRequiredPermissions(positive);
                reward.getCrate().markDirty();
                viewer.callback();
            });
        });
    }
}

