/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.reward;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.api.crate.RewardType;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.reward.RewardFactory;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.bridge.common.NightNbtHolder;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedBooleanDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.ButtonLocale;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogActions;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardCreationDialog
extends Dialog<Data> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Rewards.Creation.Title").text(RewardCreationDialog.title("Reward", "Creation"));
    private static final TextLocale INPUT_METHOD = LangEntry.builder((String)"Dialog.Rewards.Creation.Input.Method").text("Save Item as NBT");
    private static final ButtonLocale BUTTON_ITEM_TYPE = LangEntry.builder((String)"Dialog.Rewards.Creation.Button.ItemType").button(TagWrappers.SOFT_BLUE.wrap("Item Reward"), "The " + TagWrappers.SOFT_BLUE.wrap("Item") + " reward type gives the player one or more items when won." + TagWrappers.BR + TagWrappers.BR + "By default, " + TagWrappers.SOFT_YELLOW.wrap("%1$s") + " will used as the item, but you can change it at any time.");
    private static final ButtonLocale BUTTON_COMMAND_TYPE = LangEntry.builder((String)"Dialog.Rewards.Creation.Button.CommandType").button(TagWrappers.SOFT_ORANGE.wrap("Command Reward"), "The " + TagWrappers.SOFT_ORANGE.wrap("Command") + " reward type runs one or more commands when won." + TagWrappers.BR + TagWrappers.BR + "By default, " + TagWrappers.SOFT_YELLOW.wrap("%1$s") + " will used as the preview, but you can change it at any time.");
    private static final DialogElementLocale BODY_NORMAL = LangEntry.builder((String)"Dialog.Rewards.Creation.Body.Normal").dialogElement(400, new String[]{"Please select a reward type to create.", TagWrappers.GRAY.wrap("Hover over a button to see a short description of each type.")});
    private static final DialogElementLocale BODY_CUSTOM = LangEntry.builder((String)"Dialog.Rewards.Creation.Body.Custom").dialogElement(400, new String[]{"Please select a reward type to create.", TagWrappers.GRAY.wrap("Hover over a button to see a short description of each type."), "", TagWrappers.SOFT_RED.and((TagWrapper)TagWrappers.BOLD).wrap("IMPORTANT NOTE:"), "If the item above doesn't match the one you used, enable the " + TagWrappers.SOFT_RED.wrap("Save Item as NBT") + " option.", TagWrappers.GRAY.wrap("This ensures the exact item data is saved correctly.")});
    private static final String JSON_USE_NBT = "use_nbt";
    private static final String JSON_TYPE = "type";
    private final CratesPlugin plugin;

    public RewardCreationDialog(@NotNull CratesPlugin plugin) {
        this.plugin = plugin;
    }

    public void show(@NotNull Player player, @NotNull Crate crate, @NotNull ItemStack itemStack, @Nullable Runnable callback) {
        this.show(player, new Data(crate, itemStack), callback);
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Data data) {
        Crate crate = data.crate;
        ItemStack itemStack = data.itemStack;
        AdaptedItem adaptedItem = ItemHelper.adapt(itemStack);
        boolean isCustom = !adaptedItem.getAdapter().isVanilla();
        ArrayList<WrappedBooleanDialogInput> inputs = new ArrayList<WrappedBooleanDialogInput>();
        ArrayList<WrappedActionButton> buttons = new ArrayList<WrappedActionButton>();
        for (RewardType type : RewardType.values()) {
            ButtonLocale locale = (switch (type) {
                default -> throw new MatchException(null, null);
                case RewardType.ITEM -> BUTTON_ITEM_TYPE;
                case RewardType.COMMAND -> BUTTON_COMMAND_TYPE;
            }).replace(str -> str.formatted(ItemUtil.getNameSerialized((ItemStack)itemStack)));
            buttons.add(DialogButtons.action((ButtonLocale)locale).action((WrappedDialogAction)DialogActions.customClick((String)"ok", (NightNbtHolder)NightNbtHolder.builder().put(JSON_TYPE, type.name()).build())).build());
        }
        if (isCustom) {
            inputs.add(DialogInputs.bool((String)JSON_USE_NBT, (TextLocale)INPUT_METHOD).initial(false).build());
        }
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.item((ItemStack)(isCustom ? ItemHelper.toItemStack(adaptedItem) : itemStack)).build(), DialogBodies.plainMessage((DialogElementLocale)(isCustom ? BODY_CUSTOM : BODY_NORMAL))}).inputs(inputs).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((List)buttons).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                RewardType type = Enums.parse((String)nbtHolder.getText(JSON_TYPE, RewardType.ITEM.name()), RewardType.class).orElse(RewardType.ITEM);
                boolean allowCustoms = !nbtHolder.getBoolean(JSON_USE_NBT, false);
                AdaptedItem adapt = ItemHelper.adapt(itemStack, allowCustoms);
                Reward reward = RewardFactory.wizardCreation(this.plugin, crate, itemStack, type, adapt);
                crate.addReward(reward);
                crate.markDirty();
                viewer.closeFully();
            });
        });
    }

    public record Data(@NotNull Crate crate, @NotNull ItemStack itemStack) {
    }
}

