/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.generic;

import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.bridge.item.ItemAdapter;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.ItemUtil;

public abstract class GenericNameDialog<T>
extends Dialog<T> {
    private static final String JSON_NAME = "name";
    private static final String JSON_REPLACE_NAME = "replace_name";

    @NotNull
    protected abstract TextLocale title();

    @NotNull
    protected abstract AdaptedItem getItem(@NotNull T var1);

    protected abstract void setItem(@NotNull T var1, @NotNull AdaptedItem var2);

    @NotNull
    protected abstract String getName(@NotNull T var1);

    protected abstract void setName(@NotNull T var1, @NotNull String var2);

    protected abstract void save(@NotNull T var1);

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull T source) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        AdaptedItem crateItem = this.getItem(source);
        ItemAdapter itemAdapter = crateItem.getAdapter();
        inputs.add(DialogInputs.text((String)JSON_NAME, (TextLocale)Lang.DIALOG_GENERIC_NAME_INPUT_NAME).initial(this.getName(source)).maxLength(300).build());
        if (itemAdapter.isVanilla() && crateItem.isValid()) {
            inputs.add(DialogInputs.bool((String)JSON_REPLACE_NAME, (TextLocale)Lang.DIALOG_GENERIC_NAME_INPUT_REPLACE_NAME).build());
        }
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)this.title()).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)Lang.DIALOG_GENERIC_NAME_BODY)}).inputs(inputs).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String name = nbtHolder.getText(JSON_NAME, this.getName(source));
                boolean replace = nbtHolder.getBoolean(JSON_REPLACE_NAME, false);
                if (replace) {
                    ItemStack itemStack = ItemHelper.toItemStack(crateItem);
                    ItemUtil.editMeta((ItemStack)itemStack, meta -> ItemUtil.setCustomName((ItemMeta)meta, (String)name));
                    this.setItem(source, ItemHelper.vanilla(itemStack));
                }
                this.setName(source, name);
                this.save(source);
                viewer.callback();
            });
        });
    }
}

