/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.generic;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedBooleanDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.ItemUtil;

public abstract class GenericItemDialog<T>
extends Dialog<Data<T>> {
    private static final String JSON_USE_NBT = "use_nbt";
    private static final String JSON_REPLACE_NAME = "replace_name";
    private static final String JSON_REPLACE_DESCRIPTION = "replace_description";

    public void show(@NotNull Player player, @NotNull T source, @NotNull ItemStack itemStack, @Nullable Runnable callback) {
        this.show(player, new Data<T>(source, itemStack), callback);
    }

    @NotNull
    protected abstract TextLocale title();

    protected abstract void setName(@NotNull T var1, @NotNull String var2);

    protected abstract void setDescription(@NotNull T var1, @NotNull List<String> var2);

    protected abstract void setItem(@NotNull T var1, @NotNull AdaptedItem var2);

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Data<T> data) {
        Object source = data.source;
        ItemStack itemStack = data.itemStack;
        ItemMeta meta = itemStack.getItemMeta();
        AdaptedItem adaptedItem = ItemHelper.adapt(itemStack);
        boolean isCustom = !adaptedItem.getAdapter().isVanilla();
        ArrayList<WrappedBooleanDialogInput> inputs = new ArrayList<WrappedBooleanDialogInput>();
        if (meta != null) {
            if (meta.hasDisplayName() || meta.hasItemName()) {
                inputs.add(DialogInputs.bool((String)JSON_REPLACE_NAME, (TextLocale)Lang.DIALOG_GENERIC_ITEM_INPUT_REP_NAME).build());
            }
            if (meta.hasLore()) {
                inputs.add(DialogInputs.bool((String)JSON_REPLACE_DESCRIPTION, (TextLocale)Lang.DIALOG_GENERIC_ITEM_INPUT_REP_DESC).build());
            }
        }
        if (isCustom) {
            inputs.add(DialogInputs.bool((String)JSON_USE_NBT, (TextLocale)Lang.DIALOG_GENERIC_ITEM_INPUT_NBT).initial(false).build());
        }
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)this.title()).body(new WrappedDialogBody[]{DialogBodies.item((ItemStack)(isCustom ? ItemHelper.toItemStack(adaptedItem) : itemStack)).build(), DialogBodies.plainMessage((DialogElementLocale)(isCustom ? Lang.DIALOG_GENERIC_ITEM_BODY_CUSTOM : Lang.DIALOG_GENERIC_ITEM_BODY_NORMAL))}).inputs(inputs).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                boolean replaceName = nbtHolder.getBoolean(JSON_REPLACE_NAME).orElse(false);
                boolean replaceDesc = nbtHolder.getBoolean(JSON_REPLACE_DESCRIPTION).orElse(false);
                boolean allowCustoms = !nbtHolder.getBoolean(JSON_USE_NBT, false);
                AdaptedItem adapt = ItemHelper.adapt(itemStack, allowCustoms);
                if (replaceName && meta != null) {
                    this.setName(source, String.valueOf(ItemUtil.getNameSerialized((ItemMeta)meta)));
                }
                if (replaceDesc && meta != null) {
                    this.setDescription(source, ItemUtil.getLoreSerialized((ItemMeta)meta));
                }
                this.setItem(source, adapt);
                viewer.callback();
            });
        });
    }

    public record Data<T>(@NotNull T source, @NotNull ItemStack itemStack) {
    }
}

