/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.generic;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.Strings;

public abstract class GenericCreationDialog<T>
extends Dialog<T> {
    private static final String INPUT_ID = "id";

    @NotNull
    protected abstract TextLocale title();

    protected abstract boolean canCreate(@NotNull T var1, @NotNull String var2);

    protected abstract void create(@NotNull T var1, @NotNull String var2);

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull T source) {
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)this.title()).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)Lang.DIALOG_GENERIC_CREATION_BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)INPUT_ID, (String)"").labelVisible(false).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (user, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String name = nbtHolder.getText(INPUT_ID).orElse(null);
                if (name == null) {
                    return;
                }
                String id = Strings.varStyle((String)name).orElse(null);
                if (id == null || !this.canCreate(source, id)) {
                    return;
                }
                this.create(source, id);
                user.callback();
            });
        });
    }
}

