/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.crate;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CrateOpeningDialog
extends Dialog<Crate> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Crate.Opening.Title").text(CrateOpeningDialog.title("Crate", "Opening Animation"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Crate.Opening.Body").dialogElement(400, new String[]{"Select an opening animation for the crate.", "You can create and edit animations in the " + TagWrappers.SOFT_YELLOW.wrap("/openings/") + " directory.", "", TagWrappers.SOFT_YELLOW.wrap("\u2192 ") + "To disable crate opening animation, uncheck the " + TagWrappers.SOFT_YELLOW.wrap("Enabled") + " box."});
    private static final TextLocale INPUT_ENABLED = LangEntry.builder((String)"Dialog.Crate.Opening.Input.Enabled").text("Enabled");
    private static final TextLocale INPUT_OPENING = LangEntry.builder((String)"Dialog.Crate.Opening.Input.Opening").text(TagWrappers.SOFT_YELLOW.wrap("Opening"));
    private static final String JSON_ENABLED = "enabled";
    private static final String JSON_ID = "id";
    private final CratesPlugin plugin;

    public CrateOpeningDialog(@NotNull CratesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Crate crate) {
        ArrayList entries = new ArrayList();
        this.plugin.getOpeningManager().getProviderIds().stream().sorted(String::compareTo).forEach(id -> entries.add(new WrappedSingleOptionEntry(id, id, crate.getOpeningId().equalsIgnoreCase((String)id))));
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.bool((String)JSON_ENABLED, (TextLocale)INPUT_ENABLED).initial(crate.isOpeningEnabled()).build(), DialogInputs.singleOption((String)JSON_ID, (TextLocale)INPUT_OPENING, (List)entries).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                boolean enabled = nbtHolder.getBoolean(JSON_ENABLED, false);
                String id = nbtHolder.getText(JSON_ID, crate.getOpeningId());
                crate.setOpeningEnabled(enabled);
                crate.setOpeningId(id);
                crate.markDirty();
                viewer.callback();
            });
        });
    }
}

