/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.crate;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CrateHologramDialog
extends Dialog<Crate> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Crate.Hologram.Title").text(CrateHologramDialog.title("Crate", "Hologram Settings"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Crate.Hologram.Body").dialogElement(400, new String[]{"Here you can select " + TagWrappers.SOFT_YELLOW.wrap("hologram template") + " for the crate and adjust it's " + TagWrappers.SOFT_YELLOW.wrap("Y offset") + " to match the block height.", "", "You can create and edit hologram templates in the " + TagWrappers.SOFT_YELLOW.wrap("config.yml") + ".", "", TagWrappers.SOFT_YELLOW.wrap("\u2192 ") + "To disable crate hologram, uncheck the " + TagWrappers.SOFT_YELLOW.wrap("Enabled") + " box."});
    private static final TextLocale INPUT_ENABLED = LangEntry.builder((String)"Dialog.Crate.Hologram.Input.Enabled").text("Enabled");
    private static final TextLocale INPUT_TEMPLATE = LangEntry.builder((String)"Dialog.Crate.Hologram.Input.Template").text(TagWrappers.SOFT_YELLOW.wrap("Template"));
    private static final TextLocale INPUT_OFFSET = LangEntry.builder((String)"Dialog.Crate.Hologram.Input.YOffset").text(TagWrappers.SOFT_YELLOW.wrap("Y Offset"));
    private static final String JSON_ENABLED = "enabled";
    private static final String JSON_TEMPLATE = "template";
    private static final String JSON_OFFSET = "offset";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Crate crate) {
        ArrayList entries = new ArrayList();
        Config.getHologramTemplateIds().stream().sorted(String::compareTo).forEach(id -> entries.add(new WrappedSingleOptionEntry(id, id, crate.getHologramTemplateId().equalsIgnoreCase((String)id))));
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.bool((String)JSON_ENABLED, (TextLocale)INPUT_ENABLED).initial(crate.isOpeningEnabled()).build(), DialogInputs.singleOption((String)JSON_TEMPLATE, (TextLocale)INPUT_TEMPLATE, (List)entries).build(), DialogInputs.text((String)JSON_OFFSET, (TextLocale)INPUT_OFFSET).initial(String.valueOf(crate.getHologramYOffset())).maxLength(5).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                boolean enabled = nbtHolder.getBoolean(JSON_ENABLED, false);
                String id = nbtHolder.getText(JSON_TEMPLATE, crate.getOpeningId());
                double offset = nbtHolder.getDouble(JSON_OFFSET, crate.getHologramYOffset());
                crate.setHologramEnabled(enabled);
                crate.setHologramTemplateId(id);
                crate.setHologramYOffset(offset);
                crate.recreateHologram();
                crate.markDirty();
                viewer.callback();
            });
        });
    }
}

