/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.cost;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.crate.cost.entry.impl.KeyCostEntry;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.excellentcrates.key.KeyManager;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class KeyCostOptionsDialog
extends Dialog<KeyCostEntry> {
    private static final String INPUT_ID = "id";
    private static final String INPUT_AMOUNT = "amount";
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.CostEntry.Key.Title").text(KeyCostOptionsDialog.title("Cost Entry", "Key Options"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.CostEntry.Key.Body").dialogElement(400, new String[]{"Specify which key and how many of it are required to open the crate.", "", "You can create and edit keys in the " + TagWrappers.SOFT_YELLOW.wrap("ExcellentCrates Editor") + "."});
    private static final TextLocale LABEL_KEY = LangEntry.builder((String)"Dialog.CostEntry.Key.Input.Key").text(TagWrappers.SOFT_YELLOW.wrap("Key"));
    private static final TextLocale LABEL_AMOUNT = LangEntry.builder((String)"Dialog.CostEntry.Key.Input.Amount").text("Amount");
    private final KeyManager keyManager;

    public KeyCostOptionsDialog(@NotNull KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull KeyCostEntry entry) {
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.singleOption((String)INPUT_ID, (TextLocale)LABEL_KEY, this.keyManager.getKeys().stream().map(key -> new WrappedSingleOptionEntry(key.getId(), key.getName(), entry.getKeyId().equalsIgnoreCase(key.getId()))).toList()).build(), DialogInputs.text((String)INPUT_AMOUNT, (TextLocale)LABEL_AMOUNT).maxLength(10).initial(String.valueOf(entry.getAmount())).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (user, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String keyId = nbtHolder.getText(INPUT_ID, entry.getKeyId());
                int amount = nbtHolder.getInt(INPUT_AMOUNT, entry.getAmount());
                entry.setKeyId(keyId);
                entry.setAmount(amount);
                user.callback();
            });
        });
    }
}

