/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.cost;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.crate.cost.entry.impl.EcoCostEntry;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CurrencyCostOptionsDialog
extends Dialog<EcoCostEntry> {
    private static final String INPUT_ID = "id";
    private static final String INPUT_AMOUNT = "amount";
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.CostEntry.Currency.Title").text(CurrencyCostOptionsDialog.title("Cost Entry", "Currency Options"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.CostEntry.Currency.Body").dialogElement(400, new String[]{"Specify which currency and how much of it are required to open the crate.", "", "You can learn more about currency integration here: " + TagWrappers.SOFT_YELLOW.wrap(((SimpleTagWrapper)TagWrappers.OPEN_URL.with("https://nightexpressdev.com/nightcore/integrations/currencies/")).wrap("[Click to Open]"))});
    private static final TextLocale LABEL_CURRENCY = LangEntry.builder((String)"Dialog.CostEntry.Currency.Input.Currency").text(TagWrappers.SOFT_YELLOW.wrap("Currency"));
    private static final TextLocale LABEL_AMOUNT = LangEntry.builder((String)"Dialog.CostEntry.Currency.Input.Amount").text("Amount");

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull EcoCostEntry entry) {
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.singleOption((String)INPUT_ID, (TextLocale)LABEL_CURRENCY, EconomyBridge.getCurrencies().stream().map(currency -> new WrappedSingleOptionEntry(currency.getInternalId(), currency.getName(), entry.getCurrencyId().equalsIgnoreCase(currency.getInternalId()))).toList()).build(), DialogInputs.text((String)INPUT_AMOUNT, (TextLocale)LABEL_AMOUNT).maxLength(10).initial(String.valueOf(entry.getAmount())).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (user, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String currencyId = nbtHolder.getText(INPUT_ID, entry.getCurrencyId());
                double amount = nbtHolder.getDouble(INPUT_AMOUNT, entry.getAmount());
                entry.setCurrencyId(currencyId);
                entry.setAmount(amount);
                user.callback();
            });
        });
    }
}

