/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.cost;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.crate.cost.Cost;
import su.nightexpress.excellentcrates.dialog.Dialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CostNameDialog
extends Dialog<Cost> {
    private static final String INPUT_NAME = "name";
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.CostOption.Name.Title").text(CostNameDialog.title("Cost Option", "Name"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.CostOption.Name.Body").dialogElement(400, new String[]{"Sets the " + TagWrappers.SOFT_YELLOW.wrap("display name") + " for the selected cost option.", "It's best to choose a collective name, such as " + TagWrappers.SOFT_YELLOW.wrap("\"Keys\"") + " or " + TagWrappers.SOFT_YELLOW.wrap("\"Coins\"") + "."});

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Cost cost) {
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)INPUT_NAME, (String)"").initial(cost.getName()).labelVisible(false).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (user, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String name = nbtHolder.getText(INPUT_NAME, cost.getName());
                cost.setName(name);
                user.callback();
            });
        });
    }
}

