/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.data.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Optional;
import su.nightexpress.excellentcrates.data.crate.UserCrateData;

public class UserCrateDataSerializer
implements JsonSerializer<UserCrateData>,
JsonDeserializer<UserCrateData> {
    public UserCrateData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        long openCooldown = object.get("openCooldown").getAsLong();
        int openingStreak = Optional.ofNullable(object.get("openingStreak")).map(JsonElement::getAsInt).orElse(openCooldown != 0L ? 1 : 0);
        int openings = object.get("openings").getAsInt();
        int milestones = object.get("milestones").getAsInt();
        return new UserCrateData(openCooldown, openingStreak, openings, milestones);
    }

    public JsonElement serialize(UserCrateData data, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("openCooldown", (Number)data.getCooldownTimestamp());
        object.addProperty("openingStreak", (Number)data.getOpeningStreak());
        object.addProperty("openings", (Number)data.getOpenings());
        object.addProperty("milestones", (Number)data.getMilestone());
        return object;
    }
}

