/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.util.InteractType;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.ItemHandler;
import su.nightexpress.nightcore.ui.menu.item.ItemOptions;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class PreviewMenu
extends LinkedMenu<CratesPlugin, CrateSource>
implements Filled<Reward>,
ConfigBased {
    private static final String NO_PERMISSION = "%no_permission%";
    private int[] rewardSlots;
    private String rewardName;
    private List<String> rewardLore;
    private List<String> noPermissionLore;
    private List<String> limitsLore;
    private boolean hideUnavailable;

    public PreviewMenu(@NotNull CratesPlugin plugin, @NotNull FileConfig config) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, TagWrappers.BLACK.wrap("%crate_name%"));
        this.setApplyPlaceholderAPI(true);
        this.load(config);
    }

    @NotNull
    protected String getTitle(@NotNull MenuViewer viewer) {
        CrateSource source = (CrateSource)this.getLink(viewer);
        return (String)source.getCrate().replacePlaceholders().apply(this.title);
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    @NotNull
    public MenuFiller<Reward> createFiller(@NotNull MenuViewer viewer) {
        Player player = viewer.getPlayer();
        Crate crate = ((CrateSource)this.getLink(player)).getCrate();
        MenuFiller.Builder autoFill = MenuFiller.builder((Filled)this);
        autoFill.setSlots(this.rewardSlots);
        autoFill.setItems((this.hideUnavailable ? crate.getRewards(player) : crate.getRewards()).stream().filter(Reward::isRollable).toList());
        autoFill.setItemCreator(reward -> {
            ArrayList<String> restrictions = new ArrayList<String>();
            ArrayList limits = new ArrayList();
            if (reward.fitRequirements(player)) {
                if (reward.getLimits().isEnabled() && reward.getLimits().isAmountLimited()) {
                    limits.addAll(Replacer.create().replace("%amount%", () -> String.valueOf(reward.getAvailableRolls(player))).apply(this.limitsLore));
                }
            } else {
                restrictions.addAll(this.noPermissionLore);
            }
            return NightItem.fromItemStack((ItemStack)reward.getPreviewItem()).ignoreNameAndLore().setDisplayName(this.rewardName).setLore(this.rewardLore).replacement(replacer -> {
                replacer.replace("%limits%", limits).replace(NO_PERMISSION, restrictions).replace("%win_limit_amount%", limits).replace("%win_limit_cooldown%", Collections.emptyList()).replace("%win_limit_drained%", Collections.emptyList()).replace("%win_limit_no_permission%", restrictions).replace(reward.replacePlaceholders()).replace(crate.replacePlaceholders());
                if (this.applyPlaceholderAPI) {
                    replacer.replacePlaceholderAPI(player);
                }
            });
        });
        return autoFill.build();
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        this.hideUnavailable = (Boolean)ConfigValue.create((String)"Reward.Hide_Unavailable", (boolean)true, (String[])new String[]{"When enabled, displays only rewards that can be rolled out for a player."}).read(config);
        this.rewardSlots = (int[])ConfigValue.create((String)"Reward.Slots", (int[])new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34}, (String[])new String[0]).read(config);
        this.rewardName = (String)ConfigValue.create((String)"Reward.Name", (String)"%reward_name%", (String[])new String[0]).read(config);
        this.rewardLore = (List)ConfigValue.create((String)"Reward.Lore.Default", (List)Lists.newList((Object[])new String[]{NO_PERMISSION, "%empty-if-above%", TagWrappers.DARK_GRAY.wrap("\u00bb") + TagWrappers.GRAY.wrap(" Rarity: " + TagWrappers.WHITE.wrap("%reward_rarity_name%") + " \u2192 " + TagWrappers.GREEN.wrap("%reward_roll_chance%%")), "%limits%", "%empty-if-below%", "%reward_description%"}), (String[])new String[0]).read(config);
        this.noPermissionLore = (List)ConfigValue.create((String)"Reward.Lore.No_Permission", (List)Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap(TagWrappers.RED.wrap("\u2718") + " You don't have access to this reward.")}), (String[])new String[0]).read(config);
        this.limitsLore = (List)ConfigValue.create((String)"Reward.Lore.LimitInfo", (List)Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb") + TagWrappers.GRAY.wrap(" Rolls Available: ") + TagWrappers.YELLOW.wrap("%amount%")}), (String[])new String[0]).read(config);
        loader.addHandler(new ItemHandler("open", (viewer, event) -> {
            CrateSource source = (CrateSource)this.getLink(viewer);
            if (!source.hasItem() || !source.hasBlock()) {
                return;
            }
            Player player = viewer.getPlayer();
            this.runNextTick(() -> {
                player.closeInventory();
                ((CratesPlugin)this.plugin).getCrateManager().interactCrate(player, source.getCrate(), InteractType.CRATE_OPEN, source.getItem(), source.getBlock());
            });
        }, ItemOptions.builder().setVisibilityPolicy(viewer -> {
            CrateSource source = (CrateSource)this.getLink((MenuViewer)viewer);
            return source.hasItem() || source.hasBlock();
        }).build()));
        loader.addDefaultItem(new NightItem(Material.BLACK_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setSlots(new int[]{1, 2, 3, 5, 6, 7, 9, 18, 27, 17, 26, 35, 37, 38, 39, 40, 41, 42, 43}));
        loader.addDefaultItem(new NightItem(Material.GRAY_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setSlots(new int[]{0, 4, 8, 36, 44}));
        loader.addDefaultItem(NightItem.asCustomHead((String)"1daf09284530ce92ed2df2a62e1b05a11f1871f85ae559042844206d66c0b5b0").setDisplayName(TagWrappers.GOLD.wrap(TagWrappers.BOLD.wrap("Milestones"))).toMenuItem().setPriority(10).setSlots(new int[]{4}).setHandler(new ItemHandler("milestones", (viewer, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getCrateManager().openMilestones(viewer.getPlayer(), (CrateSource)this.getLink(viewer))), ItemOptions.builder().setVisibilityPolicy(viewer -> ((CrateSource)this.getLink((MenuViewer)viewer)).getCrate().hasMilestones()).build())));
        loader.addDefaultItem(MenuItem.buildExit((Menu)this, (int)40).setPriority(10));
        loader.addDefaultItem(MenuItem.buildNextPage((Menu)this, (int)26).setPriority(10));
        loader.addDefaultItem(MenuItem.buildPreviousPage((Menu)this, (int)18).setPriority(10));
    }
}

