/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.effect.impl;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.effect.CrateEffect;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class VortexEffect
extends CrateEffect {
    private static final int STRANDS = 2;
    private static final int PARTICLES = 34;
    private static final float RADIUS = 1.5f;
    private static final float CURVE = 2.0f;
    private static final double ROTATION = 0.7853981633974483;

    public VortexEffect() {
        super("vortex", 1L, 34);
    }

    @Override
    @NotNull
    public String getName() {
        return Lang.EFFECT_MODEL_VORTEX.text();
    }

    @Override
    public void onStepPlay(@NotNull Location origin, @NotNull UniParticle particle, int step, @NotNull Player player) {
        for (int boost = 0; boost < 3; ++boost) {
            for (int strand = 1; strand <= 2; ++strand) {
                float progress = (float)step / 34.0f;
                double point = (double)(2.0f * progress * 2.0f) * Math.PI / 2.0 + Math.PI * 2 * (double)strand / 2.0 + 0.7853981633974483;
                double addX = Math.cos(point) * (double)progress * 1.5;
                double addZ = Math.sin(point) * (double)progress * 1.5;
                double addY = 3.5 - 0.1 * (double)step;
                Location location = origin.clone().add(addX, addY, addZ);
                particle.play(player, location, (double)0.1f, 0.0, 1);
            }
        }
    }
}

