/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.cost.type.impl;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.cost.CostEntry;
import su.nightexpress.excellentcrates.crate.cost.entry.impl.EcoCostEntry;
import su.nightexpress.excellentcrates.crate.cost.type.AbstractCostType;
import su.nightexpress.excellentcrates.dialog.DialogRegistry;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class EcoCostType
extends AbstractCostType
implements LangContainer {
    public static final TextLocale LOCALE_NAME = LangEntry.builder((String)"Costs.Currency.Name").text(TagWrappers.GREEN.wrap("[$]") + " " + TagWrappers.WHITE.wrap("Currency"));
    public static final IconLocale LOCALE_EDIT_BUTTON = LangEntry.iconBuilder((String)"Costs.Currency.EditButton").rawName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Currency Cost") + TagWrappers.GRAY.wrap(" - ") + TagWrappers.WHITE.wrap("%name%")).rawLore(new String[]{TagWrappers.ITALIC.and((TagWrapper)TagWrappers.DARK_GRAY).wrap("Press " + TagWrappers.SOFT_RED.wrap((String)TagWrappers.KEY.apply("key.drop")) + " key to delete.")}).br().appendCurrent("Currency ID", "%id%").appendCurrent("Amount", "%amount%").br().appendClick("Click to edit").build();
    private final DialogRegistry dialogs;

    public EcoCostType(@NotNull CratesPlugin plugin, @NotNull DialogRegistry dialogs) {
        super("currency");
        this.dialogs = dialogs;
        plugin.injectLang(this);
    }

    @Override
    public boolean isAvailable() {
        return EconomyBridge.hasCurrency();
    }

    @Override
    @NotNull
    public String getName() {
        return LOCALE_NAME.text();
    }

    @Override
    @NotNull
    public CostEntry load(@NotNull FileConfig config, @NotNull String path) {
        String currencyId = (String)ConfigValue.create((String)(path + ".Currency"), (String)"vault", (String[])new String[0]).read(config);
        double amount = (Double)ConfigValue.create((String)(path + ".Amount"), (double)0.0, (String[])new String[0]).read(config);
        return new EcoCostEntry(this, this.dialogs, currencyId, amount);
    }

    @Override
    @NotNull
    public EcoCostEntry createEmpty() {
        return new EcoCostEntry(this, this.dialogs, "vault", 0.0);
    }
}

