/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.hologram.handler;

import org.bukkit.entity.Display;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.hologram.HologramHandler;

public abstract class AbstractHologramHandler
implements HologramHandler {
    protected final byte billboard = AbstractHologramHandler.translateBillboard((Display.Billboard)Config.CRATE_HOLOGRAM_BILLBOARD.get());
    protected final int lineWidth = Integer.MAX_VALUE;
    protected final byte textOpacity = ((Integer)Config.CRATE_HOLOGRAM_TEXT_OPACITY.get()).byteValue();
    protected final byte textBitmask;
    protected final int backgroundColor;

    public AbstractHologramHandler() {
        int[] bgColor = (int[])Config.CRATE_HOLOGRAM_BACKGROUND_COLOR.get();
        this.backgroundColor = AbstractHologramHandler.toARGB(bgColor[0], bgColor[1], bgColor[2], bgColor[3]);
        this.textBitmask = (byte)(((Boolean)Config.CRATE_HOLOGRAM_SHADOW.get() != false ? 1 : 0) | ((Boolean)Config.CRATE_HOLOGRAM_SEE_THROUGH.get() != false ? 2 : 0));
    }

    private static int toARGB(int alpha, int red, int green, int blue) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    private static byte translateBillboard(@NotNull Display.Billboard billboard) {
        return switch (billboard) {
            default -> throw new MatchException(null, null);
            case Display.Billboard.FIXED -> 0;
            case Display.Billboard.VERTICAL -> 1;
            case Display.Billboard.HORIZONTAL -> 2;
            case Display.Billboard.CENTER -> 3;
        };
    }
}

