/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.reward;

import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.crate.reward.impl.CommandReward;
import su.nightexpress.excellentcrates.dialog.CrateDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.text.WrappedMultilineOptions;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardCommandsDialog
extends CrateDialog<CommandReward> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Reward.Commands.Title").text(RewardCommandsDialog.title("Reward", "Commands"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Reward.Commands.Body").dialogElement(400, new String[]{"Enter the " + TagWrappers.SOFT_YELLOW.wrap("commands") + " to run when the reward is received in the Commands field.", "", TagWrappers.SOFT_YELLOW.wrap("\u2192") + " Use the " + TagWrappers.SOFT_YELLOW.wrap("%player_name%") + " placeholder to insert the name of the player who received the reward.", "", TagWrappers.SOFT_YELLOW.wrap("\u2192") + " You can use the internal " + TagWrappers.SOFT_YELLOW.wrap("Crate") + " and " + TagWrappers.SOFT_YELLOW.wrap("Reward") + " placeholders: click " + ((SimpleTagWrapper)TagWrappers.OPEN_URL.with("https://nightexpressdev.com/excellentcrates/placeholders/internal")).wrap(TagWrappers.SOFT_GREEN.and((TagWrapper)TagWrappers.UNDERLINED).wrap("HERE")) + " to view documentation.", "", TagWrappers.SOFT_YELLOW.wrap("\u2192") + " You can use any placeholders from the " + TagWrappers.SOFT_YELLOW.wrap("PlaceholderAPI") + " plugin."});
    private static final TextLocale INPUT_COMMANDS = LangEntry.builder((String)"Dialog.Reward.Commands.Input.Commands").text("Commands");
    private static final String JSON_COMMANDS = "commands";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull CommandReward reward) {
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_COMMANDS, (TextLocale)INPUT_COMMANDS).initial(String.join((CharSequence)"\n", reward.getCommands())).maxLength(400).width(300).multiline(new WrappedMultilineOptions(Integer.valueOf(10), Integer.valueOf(150))).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String commandsRaw = nbtHolder.getText(JSON_COMMANDS).orElse(null);
                if (commandsRaw == null) {
                    return;
                }
                reward.setCommands(List.of(commandsRaw.split("\n")));
                reward.getCrate().markDirty();
                viewer.callback();
            });
        });
    }
}

