/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.crate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.dialog.CrateDialog;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.bridge.common.NightNbtHolder;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.base.WrappedDialogAfterAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogActions;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.bridge.RegistryType;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class CrateParticleDialog
extends CrateDialog<Crate> {
    private static final TextLocale TITLE_MAIN = LangEntry.builder((String)"Dialog.Crate.Particle.Title").text(CrateParticleDialog.title("Crate", "Particle Type"));
    private static final TextLocale TITLE_DATA = LangEntry.builder((String)"Dialog.Crate.ParticleData.Title").text(CrateParticleDialog.title("Crate", "Particle Data"));
    private static final DialogElementLocale BODY_MAIN = LangEntry.builder((String)"Dialog.Crate.Particle.Body").dialogElement(400, new String[]{"Select the desired " + TagWrappers.SOFT_YELLOW.wrap("particle type") + ".", "", "Particles marked with an asterisk " + TagWrappers.SOFT_RED.wrap("(*)") + " have additional options that must be filled in."});
    private static final DialogElementLocale BODY_DATA_COLOR = LangEntry.builder((String)"Dialog.Crate.ParticleData.Body.Color").dialogElement(400, new String[]{"This particle type requires a " + TagWrappers.SOFT_YELLOW.wrap("color") + " specified in RGB format."});
    private static final DialogElementLocale BODY_DATA_ITEM = LangEntry.builder((String)"Dialog.Crate.ParticleData.Body.Item").dialogElement(400, new String[]{"This particle type requires an " + TagWrappers.SOFT_YELLOW.wrap("item name") + " specified."});
    private static final DialogElementLocale BODY_DATA_BLOCK = LangEntry.builder((String)"Dialog.Crate.ParticleData.Body.Block").dialogElement(400, new String[]{"This particle type requires a " + TagWrappers.SOFT_YELLOW.wrap("block name") + " specified."});
    private static final DialogElementLocale BODY_DATA_GENERIC = LangEntry.builder((String)"Dialog.Crate.ParticleData.Body.Generic").dialogElement(400, new String[]{"This particle type requires " + TagWrappers.SOFT_YELLOW.wrap("additional options") + " specified."});
    private static final TextLocale INPUT_DATA_RED = LangEntry.builder((String)"Dialog.Crate.ParticleData.Input.Red").text(TagWrappers.SOFT_RED.wrap("Red"));
    private static final TextLocale INPUT_DATA_GREEN = LangEntry.builder((String)"Dialog.Crate.ParticleData.Input.Green").text(TagWrappers.SOFT_GREEN.wrap("Green"));
    private static final TextLocale INPUT_DATA_BLUE = LangEntry.builder((String)"Dialog.Crate.ParticleData.Input.Blue").text(TagWrappers.SOFT_BLUE.wrap("Blue"));
    private static final TextLocale INPUT_DATA_ALPHA = LangEntry.builder((String)"Dialog.Crate.ParticleData.Input.Alpha").text("Alpha");
    private static final TextLocale INPUT_DATA_SIZE = LangEntry.builder((String)"Dialog.Crate.ParticleData.Input.Size").text("Size");
    private static final TextLocale INPUT_DATA_POWER = LangEntry.builder((String)"Dialog.Crate.ParticleData.Input.Power").text("Power");
    private static final TextLocale INPUT_DATA_DELAY = LangEntry.builder((String)"Dialog.Crate.ParticleData.Input.Delay").text("Delay");
    private static final TextLocale INPUT_DATA_BLOCK = LangEntry.builder((String)"Dialog.Crate.ParticleData.Input.BlockName").text("Block Name");
    private static final TextLocale INPUT_DATA_ITEM = LangEntry.builder((String)"Dialog.Crate.ParticleData.Input.ItemName").text("Item Name");
    private static final String LABEL_NORMAL = "%1$s %2$s";
    private static final String LABEL_ASTERISK = "%1$s %2$s" + TagWrappers.SOFT_RED.wrap(" (*)");
    private static final String PARTICLES_ATLAS = "particles";
    private static final float DEF_SIZE = 1.0f;
    private static final float DEF_POWER = 1.0f;
    private static final float DEF_DELAY = 0.0f;
    private static final float MIN_SIZE = 0.1f;
    private static final float MAX_SIZE = 10.0f;
    private static final float SIZE_STEP = 0.1f;
    private static final float MIN_POWER = 0.1f;
    private static final float MAX_POWER = 10.0f;
    private static final float POWER_STEP = 0.1f;
    private static final float MIN_DELAY = 0.0f;
    private static final float MAX_DELAY = 1.0f;
    private static final float DELAY_STEP = 0.05f;
    private static final int COLOR_MAX = 255;
    private static final int COLOR_MIN = 0;
    private static final String JSON_ID = "id";
    private static final String JSON_RED = "red";
    private static final String JSON_GREEN = "green";
    private static final String JSON_BLUE = "blue";
    private static final String JSON_ALPHA = "alpha";
    private static final String JSON_EXTRA = "extra";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Crate crate) {
        ArrayList buttons = new ArrayList();
        BukkitThing.getAll((RegistryType)RegistryType.PARTICLE_TYPE).stream().filter(CrateUtils::isSupportedParticle).sorted(Comparator.comparing(BukkitThing::getValue)).forEach(particle -> {
            boolean hasData = CrateParticleDialog.isConfigurable(particle);
            String localized = Lang.PARTICLE.getLocalized((Keyed)particle);
            String spriteName = CrateParticleDialog.getSprite(particle);
            String sprite = spriteName == null ? null : (String)TagWrappers.SPRITE.apply(PARTICLES_ATLAS, spriteName);
            String label = (hasData ? LABEL_ASTERISK : LABEL_NORMAL).formatted(sprite == null ? "" : sprite, localized);
            NightNbtHolder nbt = NightNbtHolder.builder().put(JSON_ID, BukkitThing.getAsString((Keyed)particle)).build();
            buttons.add(DialogButtons.action((String)label).action((WrappedDialogAction)DialogActions.customClick((String)"ok", (NightNbtHolder)nbt)).build());
        });
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE_MAIN).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY_MAIN)}).afterAction(WrappedDialogAfterAction.NONE).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((List)buttons).exitAction(DialogButtons.back()).columns(3).build());
            builder.handleResponse("back", (viewer, identifier, nbtHolder) -> viewer.callback());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String name = nbtHolder.getText(JSON_ID).orElse(null);
                if (name == null) {
                    return;
                }
                Particle particle = BukkitThing.getParticle((String)name);
                if (particle == null) {
                    return;
                }
                if (CrateParticleDialog.isConfigurable(particle)) {
                    this.openParticleData(player, crate, particle, viewer.getCallback());
                    return;
                }
                crate.setEffectParticle(UniParticle.of((Particle)particle));
                crate.markDirty();
                viewer.callback();
            });
        });
    }

    @Nullable
    private static String getSprite(@NotNull Particle particle) {
        String value = BukkitThing.getValue((Keyed)particle);
        if (Version.withCopperAge() && value.equalsIgnoreCase("copper_fire_flame")) {
            return value;
        }
        return switch (particle) {
            case Particle.ANGRY_VILLAGER -> "angry";
            case Particle.LARGE_SMOKE -> "big_smoke_5";
            case Particle.BUBBLE_POP -> "bubble_pop_1";
            case Particle.CHERRY_LEAVES -> "cherry_0";
            case Particle.CRIT -> "critical_hit";
            case Particle.DAMAGE_INDICATOR -> "damage";
            case Particle.EFFECT -> "effect_5";
            case Particle.EXPLOSION -> "explosion_10";
            case Particle.HAPPY_VILLAGER -> "glint";
            case Particle.GUST -> "gust_8";
            case Particle.HEART, Particle.INFESTED, Particle.ENCHANTED_HIT, Particle.FIREFLY, Particle.FLASH, Particle.GLOW, Particle.BUBBLE, Particle.LAVA, Particle.NAUTILUS, Particle.NOTE, Particle.RAID_OMEN, Particle.SHRIEK, Particle.SOUL_FIRE_FLAME, Particle.TRIAL_OMEN, Particle.VAULT_CONNECTION -> value;
            case Particle.TINTED_LEAVES -> "leaf_0";
            case Particle.PALE_OAK_LEAVES -> "pale_oak_0";
            case Particle.SCULK_CHARGE -> "sculk_charge_3";
            case Particle.SCULK_CHARGE_POP -> "sculk_charge_pop_0";
            case Particle.SCULK_SOUL -> "sculk_soul_5";
            case Particle.SMALL_GUST -> "small_gust_4";
            case Particle.SONIC_BOOM -> "sonic_boom_10";
            case Particle.SOUL -> "soul_1";
            case Particle.ELECTRIC_SPARK -> "spark_5";
            case Particle.SPLASH -> "splash_0";
            case Particle.SWEEP_ATTACK -> "sweep_3";
            case Particle.TRIAL_SPAWNER_DETECTION -> "trial_spawner_detection_0";
            case Particle.TRIAL_SPAWNER_DETECTION_OMINOUS -> "trial_spawner_detection_ominous_0";
            default -> null;
        };
    }

    private void openParticleData(@NotNull Player player, @NotNull Crate crate, @NotNull Particle particle, @Nullable Runnable originCallback) {
        Function<NightNbtHolder, Object> dataParser;
        DialogElementLocale bodyLocale;
        Class type = particle.getDataType();
        ArrayList<Object> inputs = new ArrayList<Object>();
        if (type == Color.class) {
            bodyLocale = BODY_DATA_COLOR;
            inputs.addAll(this.getColorButtons());
            dataParser = CrateParticleDialog::parseColor;
        } else if (type == Particle.DustOptions.class) {
            bodyLocale = BODY_DATA_COLOR;
            inputs.add(DialogInputs.numberRange((String)JSON_EXTRA, (TextLocale)INPUT_DATA_SIZE, (float)0.1f, (float)10.0f).initial(Float.valueOf(1.0f)).step(Float.valueOf(0.1f)).build());
            inputs.addAll(this.getColorButtons());
            dataParser = nbtHolder -> {
                Color color = CrateParticleDialog.parseColor(nbtHolder);
                float size = nbtHolder.getFloat(JSON_EXTRA, 1.0f);
                return new Particle.DustOptions(color, size);
            };
        } else if (type.getSimpleName().equalsIgnoreCase("Spell")) {
            bodyLocale = BODY_DATA_COLOR;
            inputs.add(DialogInputs.numberRange((String)JSON_EXTRA, (TextLocale)INPUT_DATA_POWER, (float)0.1f, (float)10.0f).initial(Float.valueOf(1.0f)).step(Float.valueOf(0.1f)).build());
            inputs.addAll(this.getColorButtons());
            dataParser = nbtHolder -> {
                Color color = CrateParticleDialog.parseColor(nbtHolder);
                float power = nbtHolder.getFloat(JSON_EXTRA, 1.0f);
                return new Particle.Spell(color, power);
            };
        } else if (type == ItemStack.class) {
            bodyLocale = BODY_DATA_ITEM;
            inputs.add(DialogInputs.text((String)JSON_EXTRA, (TextLocale)INPUT_DATA_ITEM).build());
            dataParser = nbtHolder -> {
                String name = nbtHolder.getText(JSON_EXTRA).orElse(null);
                Material material = name == null ? null : BukkitThing.getMaterial((String)name);
                return material == null ? null : new ItemStack(material);
            };
        } else if (type == BlockData.class) {
            bodyLocale = BODY_DATA_BLOCK;
            inputs.add(DialogInputs.text((String)JSON_EXTRA, (TextLocale)INPUT_DATA_BLOCK).build());
            dataParser = nbtHolder -> {
                String name = nbtHolder.getText(JSON_EXTRA).orElse(null);
                Material material = name == null ? null : BukkitThing.getMaterial((String)name);
                return material == null ? null : material.createBlockData();
            };
        } else {
            bodyLocale = BODY_DATA_GENERIC;
            if (particle == Particle.DRAGON_BREATH) {
                inputs.add(DialogInputs.numberRange((String)JSON_EXTRA, (TextLocale)INPUT_DATA_DELAY, (float)0.0f, (float)1.0f).initial(Float.valueOf(0.0f)).step(Float.valueOf(0.05f)).build());
                dataParser = nbtHolder -> nbtHolder.getFloat(JSON_EXTRA).orElse(Float.valueOf(0.0f));
            } else {
                dataParser = nbtHolder -> null;
            }
        }
        Dialogs.createAndShow((Player)player, builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE_DATA).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)bodyLocale)}).inputs(inputs).afterAction(WrappedDialogAfterAction.NONE).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("back", (viewer, identifier, nbtHolder) -> viewer.callback());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                Object data = dataParser.apply(nbtHolder);
                if (data != null) {
                    crate.setEffectParticle(UniParticle.of((Particle)particle, data));
                    crate.markDirty();
                }
                viewer.callback();
            });
        }, (Runnable)originCallback);
    }

    @NotNull
    private static Color parseColor(@NotNull NightNbtHolder nbtHolder) {
        int red = nbtHolder.getInt(JSON_RED, 255);
        int green = nbtHolder.getInt(JSON_GREEN, 255);
        int blue = nbtHolder.getInt(JSON_BLUE, 255);
        int alpha = nbtHolder.getInt(JSON_ALPHA, 255);
        return Color.fromARGB((int)alpha, (int)red, (int)green, (int)blue);
    }

    @NotNull
    private List<WrappedDialogInput> getColorButtons() {
        ArrayList<WrappedDialogInput> inputs = new ArrayList<WrappedDialogInput>();
        inputs.add((WrappedDialogInput)DialogInputs.numberRange((String)JSON_RED, (TextLocale)INPUT_DATA_RED, (float)0.0f, (float)255.0f).initial(Float.valueOf(255.0f)).step(Float.valueOf(1.0f)).build());
        inputs.add((WrappedDialogInput)DialogInputs.numberRange((String)JSON_GREEN, (TextLocale)INPUT_DATA_GREEN, (float)0.0f, (float)255.0f).initial(Float.valueOf(255.0f)).step(Float.valueOf(1.0f)).build());
        inputs.add((WrappedDialogInput)DialogInputs.numberRange((String)JSON_BLUE, (TextLocale)INPUT_DATA_BLUE, (float)0.0f, (float)255.0f).initial(Float.valueOf(255.0f)).step(Float.valueOf(1.0f)).build());
        inputs.add((WrappedDialogInput)DialogInputs.numberRange((String)JSON_ALPHA, (TextLocale)INPUT_DATA_ALPHA, (float)0.0f, (float)255.0f).initial(Float.valueOf(255.0f)).step(Float.valueOf(1.0f)).build());
        return inputs;
    }

    private static boolean isConfigurable(@NotNull Particle particle) {
        if (particle == Particle.DRAGON_BREATH) {
            return true;
        }
        Class type = particle.getDataType();
        return type != Void.class && type != Integer.class && type != Float.class && type != Vibration.class && type != Particle.Trail.class && type != Particle.DustTransition.class;
    }
}

