/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.util;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.config.Keys;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.Strings;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class CrateUtils {
    public static final int REWARD_ITEMS_LIMIT = 27;

    @NotNull
    public static Set<Player> getPlayersForEffects(@NotNull Location location) {
        HashSet<Player> players = new HashSet<Player>(Bukkit.getServer().getOnlinePlayers());
        players.removeIf(player -> !CrateUtils.isInEffectRange(player, location));
        return players;
    }

    public static boolean isInEffectRange(@NotNull Player player, @NotNull Location location) {
        World world = location.getWorld();
        int distance = (Integer)Config.CRATE_EFFECTS_VISIBILITY_DISTANCE.get();
        return player.getWorld() == world && player.getLocation().distance(location) <= (double)distance;
    }

    @NotNull
    public static ItemStack removeCrateTags(@NotNull ItemStack itemStack) {
        ItemUtil.editMeta((ItemStack)itemStack, meta -> {
            PDCUtil.remove((PersistentDataHolder)meta, (NamespacedKey)Keys.crateId);
            PDCUtil.remove((PersistentDataHolder)meta, (NamespacedKey)Keys.keyId);
        });
        return itemStack;
    }

    @NotNull
    public static ItemStack getQuestionStack() {
        return NightItem.asCustomHead((String)"2705fd94a0c431927fb4e639b0fcfb49717e412285a02b439e0112da22b2e2ec").hideAllComponents().getItemStack();
    }

    @NotNull
    public static NightItem getDefaultLinkTool() {
        return NightItem.fromType((Material)Material.BLAZE_ROD).hideAllComponents().setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Link Tool")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Click a block to link it"), TagWrappers.GRAY.wrap("with the crate!")}));
    }

    @NotNull
    public static ItemStack getDefaultItem(@NotNull Crate crate) {
        return NightItem.fromType((Material)Material.CHEST).setDisplayName(crate.getName()).setLore(crate.getDescription()).hideAllComponents().getItemStack();
    }

    @Deprecated
    @NotNull
    public static String createID(@NotNull String name) {
        String id = StringUtil.transformForID((String)name);
        if (id.isBlank()) {
            id = UUID.randomUUID().toString().substring(0, 8);
        }
        return id;
    }

    @NotNull
    public static String generateRewardID(@NotNull Crate crate, @NotNull ItemStack itemStack) {
        String itemName = Optional.ofNullable(ItemUtil.getDisplayNameSerialized((ItemStack)itemStack)).map(NightMessage::stripTags).orElse(BukkitThing.getValue((Keyed)itemStack.getType()));
        String name = Strings.varStyle((String)itemName).orElse(UUID.randomUUID().toString());
        int count = 0;
        while (crate.getReward(CrateUtils.addCount(name, count)) != null) {
            ++count;
        }
        return CrateUtils.addCount(name, count);
    }

    private static String addCount(@NotNull String str, int count) {
        return count <= 0 ? str : str + "_" + count;
    }

    public static boolean isSupportedParticle(@NotNull Particle particle) {
        return particle != Particle.VIBRATION && particle != Particle.DUST_COLOR_TRANSITION && particle != Particle.TRAIL;
    }

    public static boolean isSupportedParticleData(@NotNull UniParticle particle) {
        return particle.getParticle() != null && CrateUtils.isSupportedParticleData(particle.getParticle().getDataType());
    }

    public static boolean isSupportedParticleData(@NotNull Class<?> clazz) {
        return clazz != Void.class && clazz != Vibration.class && clazz != Particle.DustTransition.class && clazz != Particle.Trail.class;
    }
}

