/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.crate;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Keyed;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.dialog.CrateDialog;
import su.nightexpress.excellentcrates.dialog.CrateDialogs;
import su.nightexpress.excellentcrates.registry.CratesRegistries;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.base.WrappedDialogAfterAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.ButtonLocale;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogActions;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CrateEffectDialog
extends CrateDialog<Crate> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Crate.Effect.Title").text(CrateEffectDialog.title("Crate", "Block Effect"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Crate.Effect.Body").dialogElement(400, new String[]{"Here you can choose the " + TagWrappers.SOFT_YELLOW.wrap("effect model") + " and " + TagWrappers.SOFT_YELLOW.wrap("particle type") + " for the crate.", "These effects are shown around the blocks linked to the crate."});
    private static final TextLocale INPUT_MODEL = LangEntry.builder((String)"Dialog.Crate.Effect.Input.Model").text(TagWrappers.SOFT_YELLOW.wrap("Effect Model"));
    private static final ButtonLocale BUTTON_PARTICLE = LangEntry.builder((String)"Dialog.Crate.Effect.Button.Particle").button(TagWrappers.SOFT_YELLOW.wrap("Particle: ") + "%s");
    private static final String ACTION_PARTICLE = "particle";
    private static final String JSON_MODEL = "model";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Crate crate) {
        ArrayList entries = new ArrayList();
        CratesRegistries.getEffects().forEach(effect -> entries.add(new WrappedSingleOptionEntry(effect.getId(), effect.getName(), crate.getEffect() == effect)));
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.singleOption((String)JSON_MODEL, (TextLocale)INPUT_MODEL, (List)entries).build()}).afterAction(WrappedDialogAfterAction.NONE).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.action((ButtonLocale)BUTTON_PARTICLE.replace(str -> str.formatted(Lang.PARTICLE.getLocalized((Keyed)crate.getEffectParticle().getParticle())))).action((WrappedDialogAction)DialogActions.customClick((String)ACTION_PARTICLE)).build(), DialogButtons.ok()}).exitAction(DialogButtons.back()).columns(1).build());
            builder.handleResponse(ACTION_PARTICLE, (viewer, identifier, nbtHolder) -> CrateDialogs.CRATE_PARTICLE.ifPresent(dialog -> dialog.show(player, crate, () -> this.show(player, crate, viewer.getCallback()))));
            builder.handleResponse("back", (viewer, identifier, nbtHolder) -> viewer.closeFully());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                crate.setEffectType(nbtHolder.getText(JSON_MODEL, crate.getEffectType()));
                crate.markDirty();
                viewer.closeFully();
            });
        });
    }
}

