/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.reward;

import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.Rarity;
import su.nightexpress.excellentcrates.crate.limit.CooldownMode;
import su.nightexpress.excellentcrates.crate.limit.LimitValues;
import su.nightexpress.excellentcrates.data.reward.RewardData;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.problem.ProblemCollector;
import su.nightexpress.nightcore.util.problem.ProblemReporter;

public abstract class AbstractReward
implements Reward {
    protected final CratesPlugin plugin;
    protected final Crate crate;
    protected final String id;
    protected AdaptedItem preview;
    protected double weight;
    protected Rarity rarity;
    protected boolean broadcast;
    protected LimitValues limits;
    protected Set<String> ignoredPermissions;
    protected Set<String> requiredPermissions;

    public AbstractReward(@NotNull CratesPlugin plugin, @NotNull Crate crate, @NotNull String id, @NotNull Rarity rarity) {
        this.plugin = plugin;
        this.crate = crate;
        this.id = id.toLowerCase();
        this.setWeight(10.0);
        this.setRarity(rarity);
        this.setPreview(ItemHelper.vanilla(CrateUtils.getQuestionStack()));
        this.setBroadcast(false);
        this.setLimits(LimitValues.unlimited());
        this.setIgnoredPermissions(new HashSet<String>());
        this.setRequiredPermissions(new HashSet<String>());
    }

    @Override
    public void load(@NotNull FileConfig config, @NotNull String path) {
        if (config.contains(path + ".Win_Limit")) {
            boolean playerEnabled = config.getBoolean(path + ".Win_Limit.Player.Enabled", false);
            int playerAmount = config.getInt(path + ".Win_Limit.Player.Amount", -1);
            long playerCooldown = config.getLong(path + ".Win_Limit.Player.Cooldown");
            boolean globalEnabled = config.getBoolean(path + ".Win_Limit.Global.Enabled", false);
            int globalAmount = config.getInt(path + ".Win_Limit.Global.Amount", -1);
            long globalCooldown = config.getLong(path + ".Win_Limit.Global.Cooldown");
            CooldownMode cooldownType = playerCooldown == -2L || globalCooldown == -2L ? CooldownMode.DAILY : CooldownMode.CUSTOM;
            LimitValues values = new LimitValues(playerEnabled || globalEnabled, cooldownType, globalAmount, playerAmount, globalCooldown, playerCooldown);
            config.set(path + ".Limits", (Object)values);
            config.remove(path + ".Win_Limit");
        }
        this.setPreview(ItemHelper.readOrPlaceholder(config, path + ".PreviewData"));
        this.setWeight(config.getDouble(path + ".Weight", -1.0));
        this.setBroadcast(config.getBoolean(path + ".Broadcast"));
        this.setLimits(LimitValues.read(config, path + ".Limits"));
        this.setIgnoredPermissions(config.getStringSet(path + ".Ignored_For_Permissions"));
        this.setRequiredPermissions(config.getStringSet(path + ".Required_Permissions"));
        this.loadAdditional(config, path);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Type", (Object)this.getType().name());
        config.set(path + ".PreviewData", (Object)this.preview);
        config.set(path + ".Weight", (Object)this.weight);
        config.set(path + ".Rarity", (Object)this.rarity.getId());
        config.set(path + ".Broadcast", (Object)this.broadcast);
        config.set(path + ".Limits", (Object)this.limits);
        config.set(path + ".Ignored_For_Permissions", this.ignoredPermissions);
        config.set(path + ".Required_Permissions", this.requiredPermissions);
        this.writeAdditional(config, path);
    }

    protected abstract void loadAdditional(@NotNull FileConfig var1, @NotNull String var2);

    protected abstract void writeAdditional(@NotNull FileConfig var1, @NotNull String var2);

    @Override
    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return Placeholders.REWARD.replacer((Object)this);
    }

    @NotNull
    protected Replacer createContentReplacer(@NotNull Player player) {
        return Replacer.create().replace(this.crate.replacePlaceholders()).replace(this.replacePlaceholders());
    }

    @Override
    @NotNull
    public ProblemReporter collectProblems() {
        ProblemCollector reporter = new ProblemCollector(this.getId(), String.valueOf(this.crate.getPath()) + " -> " + this.id);
        this.collectAdditionalProblems((ProblemReporter)reporter);
        return reporter;
    }

    protected abstract void collectAdditionalProblems(@NotNull ProblemReporter var1);

    @Override
    public boolean hasProblems() {
        return !this.collectProblems().isEmpty();
    }

    @Override
    public boolean isOnCooldown(@NotNull Player player) {
        RewardData globalLimit;
        if (!this.limits.isEnabled()) {
            return false;
        }
        if (this.limits.hasGlobalCooldown() && (globalLimit = this.plugin.getDataManager().getRewardLimit(this, null)) != null && globalLimit.isOnCooldown()) {
            return true;
        }
        if (this.limits.hasPlayerCooldown()) {
            RewardData playerLimit = this.plugin.getDataManager().getRewardLimit(this, player);
            return playerLimit != null && playerLimit.isOnCooldown();
        }
        return false;
    }

    @Override
    public int getAvailableRolls(@NotNull Player player) {
        RewardData globalLimit = this.plugin.getDataManager().getRewardLimit(this, null);
        RewardData playerLimit = this.plugin.getDataManager().getRewardLimit(this, player);
        int globalLeft = -1;
        int playerLeft = -1;
        if (this.limits.isEnabled()) {
            if (this.limits.isGlobalAmountLimited()) {
                int n = globalLeft = globalLimit == null ? this.limits.getGlobalAmount() : Math.max(0, this.limits.getGlobalAmount() - globalLimit.getRolls());
            }
            if (this.limits.isPlayerAmountLimited()) {
                int n = playerLeft = playerLimit == null ? this.limits.getPlayerAmount() : Math.max(0, this.limits.getPlayerAmount() - playerLimit.getRolls());
            }
        }
        if (globalLeft < 0 || playerLeft < 0) {
            return Math.max(playerLeft, globalLeft);
        }
        return Math.min(playerLeft, globalLeft);
    }

    @Override
    public boolean isRollable() {
        return this.weight > 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasBadPermissions(@NotNull Player player) {
        if (this.ignoredPermissions.isEmpty()) return false;
        if (!this.ignoredPermissions.stream().anyMatch(arg_0 -> ((Player)player).hasPermission(arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasRequiredPermissions(@NotNull Player player) {
        if (this.requiredPermissions.isEmpty()) return true;
        if (!this.requiredPermissions.stream().anyMatch(arg_0 -> ((Player)player).hasPermission(arg_0))) return false;
        return true;
    }

    @Override
    public boolean fitRequirements(@NotNull Player player) {
        return !this.hasBadPermissions(player) && this.hasRequiredPermissions(player);
    }

    @Override
    public boolean canWin(@NotNull Player player) {
        if (!this.isRollable()) {
            return false;
        }
        if (!this.fitRequirements(player)) {
            return false;
        }
        return !this.isOnCooldown(player) && this.getAvailableRolls(player) != 0;
    }

    @Override
    public void give(@NotNull Player player) {
        this.plugin.getCrateManager().giveReward(player, this);
    }

    @Override
    public double getRollChance() {
        double sum = this.crate.getRewards(this.rarity).stream().mapToDouble(Reward::getWeight).sum();
        double rarityChance = this.rarity.getRollChance(this.crate);
        double chance = this.weight / sum * (rarityChance / 100.0);
        return chance * 100.0;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Crate getCrate() {
        return this.crate;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = Math.max(0.0, weight);
    }

    @Override
    @NotNull
    public AdaptedItem getPreview() {
        return this.preview;
    }

    @Override
    public void setPreview(@NotNull AdaptedItem provider) {
        this.preview = provider;
    }

    @Override
    @NotNull
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public void setRarity(@NotNull Rarity rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean isBroadcast() {
        return this.broadcast;
    }

    @Override
    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    @Override
    @NotNull
    public LimitValues getLimits() {
        return this.limits;
    }

    @Override
    public void setLimits(@NotNull LimitValues limitValues) {
        this.limits = limitValues;
    }

    @Override
    @NotNull
    public Set<String> getIgnoredPermissions() {
        return this.ignoredPermissions;
    }

    @Override
    public void setIgnoredPermissions(@NotNull Set<String> ignoredPermissions) {
        this.ignoredPermissions = ignoredPermissions;
    }

    @Override
    @NotNull
    public Set<String> getRequiredPermissions() {
        return this.requiredPermissions;
    }

    @Override
    public void setRequiredPermissions(@NotNull Set<String> requiredPermissions) {
        this.requiredPermissions = requiredPermissions;
    }
}

