/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.effect.impl;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.effect.CrateEffect;
import su.nightexpress.excellentcrates.util.pos.Point3D;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class HeartEffect
extends CrateEffect {
    private static final int POINTS = 20;
    private boolean rotate = false;

    public HeartEffect() {
        super("heart", 1L, 20);
    }

    @Override
    @NotNull
    public String getName() {
        return Lang.EFFECT_MODEL_HEART.text();
    }

    @Override
    public void onStepPlay(@NotNull Location origin, @NotNull UniParticle particle, int step, @NotNull Player player) {
        boolean isX = this.rotate;
        origin = origin.add(0.0, 4.0, 0.0);
        double delta = 0.15707963267948966;
        double angle = delta * (double)step;
        double z = 16.0 * Math.pow(Math.sin(angle), 3.0);
        double y = 13.0 * Math.cos(angle) - 5.0 * Math.cos(2.0 * angle) - 2.0 * Math.cos(3.0 * angle) - Math.cos(4.0 * angle);
        double x = 0.0;
        double realX = isX ? z : x;
        double realZ = isX ? x : z;
        Point3D point = new Point3D(realX / 25.0, y / 25.0 - 1.8, realZ / 25.0);
        Point3D mirrored = new Point3D(isX ? -point.x : point.x, point.y, isX ? point.z : -point.z);
        Location left = origin.clone().add(point.x, point.y, point.z);
        Location right = origin.clone().add(mirrored.x, mirrored.y, mirrored.z);
        particle.play(player, left, 0.0, 1);
        particle.play(player, right, 0.0, 1);
        if (step == 0) {
            this.rotate = !this.rotate;
        }
    }
}

