/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.hologram.HologramTemplate;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.time.TimeFormatType;

public class Config {
    public static final String DIR_CRATES = "/crates/";
    public static final String DIR_PREVIEWS = "/previews/";
    public static final String DIR_KEYS = "/keys/";
    public static final String DIR_MENUS = "/menu/";
    public static final String DIR_UI = "/ui/";
    public static final String DIR_OPENINGS = "/openings/";
    public static final String DIR_OPENINGS_INVENTORY = "/openings/inventory/";
    public static final String DIR_OPENINGS_SELECTABLE = "/openings/selectable/";
    public static final String DIR_OPENINGS_SIMPLE_ROLL = "/openings/simple_roll/";
    public static final String FILE_MILESTONES = "milestones.yml";
    public static final String FILE_LOGS = "openings.log";
    public static final ConfigValue<String> LOGS_DATE_FORMAT = ConfigValue.create((String)"Logs.DateFormat", (String)"dd/MM/yyyy HH:mm:ss", (String[])new String[]{"Sets date format for crate opening logs."});
    public static final ConfigValue<Boolean> LOGS_TO_CONSOLE = ConfigValue.create((String)"Logs.Enabled.Console", (boolean)false, (String[])new String[]{"Sets whether or not all crate openings & reward wins will be logged to console."});
    public static final ConfigValue<Boolean> LOGS_TO_FILE = ConfigValue.create((String)"Logs.Enabled.File", (boolean)true, (String[])new String[]{"Sets whether or not all crate openings & reward wins will be logged to a file."});
    public static final ConfigValue<Boolean> DATA_REWARD_LIMITS_SYNC_ENABLED = ConfigValue.create((String)"Data.Rewards.Limits.Synchronize", (boolean)true, (String[])new String[]{"When enabled, synchronizes reward limits datas (both, global and player ones) in addition to player data sync.", "[*] CAUTION: Removes all reward limit entries from the database when a crate/reward gets deleted.", "[*] Useless for SQLite."});
    public static final ConfigValue<Integer> DATA_REWARD_LIMITS_SAVE_INTERVAL = ConfigValue.create((String)"Data.Rewards.Limits.Save_Interval", (int)3, (String[])new String[]{"Sets auto-save interval for reward's limit datas.", "Data also saved on plugin reload and server reboot.", "[*] You can increase this value to improve performance if you don't sync/share reward limit data across multiple servers."});
    public static final ConfigValue<Boolean> DATA_CRATE_DATA_SYNC_ENABLED = ConfigValue.create((String)"Data.Crates.GlobalData.Synchronize", (boolean)true, (String[])new String[]{"When enabled, synchronizes global crate datas in addition to player data sync.", "[*] CAUTION: Removes all crate data entries from the database when a crate gets deleted.", "[*] Useless for SQLite."});
    public static final ConfigValue<Integer> DATA_CRATE_DATA_SAVE_INTERVAL = ConfigValue.create((String)"Data.Crates.GlobalData.Save_Interval", (int)60, (String[])new String[]{"Sets auto-save interval for crate's datas.", "Data also saved on plugin reload and server reboot.", "Crate data stores the following information:", "- Latest opener ID", "- Latest opener Name", "- Latest reward ID", "[*] You can increase this value to improve performance if you don't sync/share crate data across multiple servers."});
    public static final ConfigValue<Boolean> FEATURE_MASS_OPENING = ConfigValue.create((String)"Features.MassOpening", (boolean)true, (String[])new String[]{"Whether Mass Opening feature is enabled."});
    public static final ConfigValue<Boolean> MILESTONES_ENABLED = ConfigValue.create((String)"Milestones.Enabled", (boolean)true, (String[])new String[]{"Controls whether Milestones feature is enabled."});
    public static final ConfigValue<Integer> CRATE_SAVE_INTERVAL = ConfigValue.create((String)"Crate.SaveInterval", (int)300, (String[])new String[]{"Sets save interval (in seconds) for crates that were changed using the in-game editor.", "[Default is 300 (5 min)]"});
    public static final ConfigValue<NightItem> CRATE_LINK_TOOL = ConfigValue.create((String)"Crate.LinkTool", (NightItem)CrateUtils.getDefaultLinkTool(), (String[])new String[]{"Sets the Link Tool item layout."});
    public static final ConfigValue<Boolean> CRATE_ALLOW_CRATES_IN_AIR_BLOCKS = ConfigValue.create((String)"Crate.Allow_Crates_In_Air_Blocks", (boolean)false, (String[])new String[]{"When enabled allows crates to be assigned to 'air' blocks and disables block validation on crate load."});
    public static final ConfigValue<Integer> CRATE_EFFECTS_VISIBILITY_DISTANCE = ConfigValue.create((String)"Crate.Effects.Visibility_Distance", (int)24, (String[])new String[]{"Sets max. distance where players can see crate particles and holograms."});
    public static final ConfigValue<Map<String, HologramTemplate>> CRATE_HOLOGRAM_TEMPLATES = ConfigValue.forMapById((String)"Crate.Holograms.TemplateList", HologramTemplate::read, map -> map.putAll(HologramTemplate.getDefaultTemplates()), (String[])new String[]{"Custom hologram templates to display above crate blocks.", "Allowed Placeholders:", "- PlaceholderAPI placeholders.", "- Crate placeholders: https://nightexpressdev.com/excellentcrates/placeholders/internal"});
    public static final ConfigValue<Double> CRATE_HOLOGRAM_LINE_GAP = ConfigValue.create((String)"Crate.Holograms.LineGap", (double)0.3, (String[])new String[]{"Sets the gap between hologram lines."});
    public static final ConfigValue<Integer> CRATE_HOLOGRAM_UPDATE_INTERVAL = ConfigValue.create((String)"Crate.Holograms.Update_Interval", (int)5, (String[])new String[]{"Sets how often (in seconds) crate holograms will update."});
    public static final ConfigValue<TimeFormatType> CRATE_COOLDOWN_FORMAT_TYPE = ConfigValue.create((String)"Crate.Cooldown_Format_Type", TimeFormatType.class, (Enum)TimeFormatType.DIGITAL, (String[])new String[]{"Sets crate cooldown format type.", "Available values: [" + Enums.inline(TimeFormatType.class) + "]"});
    public static final ConfigValue<Boolean> OPENING_CONFIRM_FOR_SINGLE_COST = ConfigValue.create((String)"Crate.Opening.Confirmation.ForSingleCost", (boolean)false, (String[])new String[]{"Controls whether the Costs GUI will appear even if there is only cost option available."});
    public static final ConfigValue<Boolean> MASS_OPENING_ALLOW_FOR_NO_COST = ConfigValue.create((String)"Crate.MassOpening.AllowForNoCost", (boolean)false, (String[])new String[]{"Controls whether players can do Mass Opening for crates with no cost options defined."});
    public static final ConfigValue<Boolean> MASS_OPENING_SNEAK_TO_USE = ConfigValue.create((String)"Crate.MassOpening.SneakToUse", (boolean)true, (String[])new String[]{"Controls whether players can do Mass Opening by opening crates while sneaking."});
    public static final ConfigValue<Integer> MASS_OPENING_LIMIT = ConfigValue.create((String)"Crate.Mass_Opening_Limit", (int)30, (String[])new String[]{"Limits amount of crate openings for the Mass Opening feature to this value.", "[*] STABILITY NOTICE:", "  Stability highly depends on reward's content.", "  Using high values may result in freezes, stutters, bugs and errors."});
    public static final ConfigValue<Long> CRATE_PREVIEW_COOLDOWN = ConfigValue.create((String)"Crate.Preview_Cooldown", (long)2500L, (String[])new String[]{"Sets cooldown (in milliseconds) for crate preview by clicking crate block(s).", "The main purpose of this setting is to prevent exploit using hacked clients by sending a lot of crate interaction packets causing server overload by GUI generation.", "Resets on player quit.", "[Default is 2500]"});
    public static final ConfigValue<Double> CRATE_PUSHBACK_Y = ConfigValue.create((String)"Crate.Block_Pushback.Y", (double)-0.4, (String[])new String[]{"Sets the Y offset for crate block pushback."});
    public static final ConfigValue<Double> CRATE_PUSHBACK_MULTIPLY = ConfigValue.create((String)"Crate.Block_Pushback.Multiply", (double)-1.25, (String[])new String[]{"Vector multiplier for crate block pushback. The higher value - the harder pushback."});
    public static final ConfigValue<Boolean> CRATE_REVERSE_CLICK_ACTIONS = ConfigValue.create((String)"Crate.Reverse_Click_Actions", (boolean)false, (String[])new String[]{"Controls whether click actions, when interacting with crate blocks, should be reversed.", "By default it uses Left Click to preview crates, and Right Click to open them."});
    public static final ConfigValue<Boolean> HOLOGRAMS_ENABLED = ConfigValue.create((String)"Holograms.Enabled", (boolean)true, (String[])new String[]{"Controls whether the Holograms feature is available.", "[*] One of the following plugins is required for holograms to work: packetevents or ProtocolLib"});
    public static final ConfigValue<Boolean> OPENINGS_GUI_SIMULATE_REAL_CHANCES = ConfigValue.create((String)"Openings.GUI.Simulate_Real_Chances", (boolean)false, (String[])new String[]{"[ THIS SETTING DOES NOT AFFECT THE FINAL REWARD, IT IS PREDICTED WHEN PLAYER OPENED A CRATE ]", "Controls whether reward's weight and rarity should be respected when displaying rewards during GUI opening animation.", "When disabled, rewards choosen by a blind random.", "[Default is false]"});

    public static boolean isMilestonesEnabled() {
        return (Boolean)MILESTONES_ENABLED.get();
    }

    public static boolean isCrateDataSynchronized() {
        return (Boolean)DATA_CRATE_DATA_SYNC_ENABLED.get();
    }

    public static boolean isRewardLimitsSynchronized() {
        return (Boolean)DATA_REWARD_LIMITS_SYNC_ENABLED.get();
    }

    @NotNull
    public static List<String> getHologramTemplateIds() {
        return new ArrayList<String>(((Map)CRATE_HOLOGRAM_TEMPLATES.get()).keySet());
    }

    @Nullable
    public static HologramTemplate getHologramTemplate(@NotNull String id) {
        return (HologramTemplate)((Map)CRATE_HOLOGRAM_TEMPLATES.get()).get(id.toLowerCase());
    }

    public static boolean isCrateInAirBlocksAllowed() {
        return (Boolean)CRATE_ALLOW_CRATES_IN_AIR_BLOCKS.get();
    }

    public static boolean isMassOpenEnabled() {
        return (Boolean)FEATURE_MASS_OPENING.get();
    }
}

