/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.hologram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.text.tag.Tags;

public class HologramTemplate
implements Writeable {
    private final String id;
    private final List<String> text;

    public HologramTemplate(@NotNull String id, @NotNull List<String> text) {
        this.id = id.toLowerCase();
        this.text = text;
    }

    @NotNull
    public static HologramTemplate read(@NotNull FileConfig config, @NotNull String path, @NotNull String id) {
        List text = config.getStringList(path + ".Text");
        return new HologramTemplate(id, text);
    }

    @NotNull
    public static Map<String, HologramTemplate> getDefaultTemplates() {
        HashMap<String, HologramTemplate> map = new HashMap<String, HologramTemplate>();
        HologramTemplate template1 = new HologramTemplate("default", Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.wrap(Tags.BOLD.wrap("%crate_name%")), Tags.LIGHT_GRAY.wrap("You can open this crate " + Tags.LIGHT_YELLOW.wrap("%excellentcrates_openings_available_%crate_id%%") + " times."), Tags.LIGHT_GRAY.wrap("Edit templates in " + Tags.LIGHT_YELLOW.wrap("config.yml"))}));
        HologramTemplate template2 = new HologramTemplate("example", Lists.newList((Object[])new String[]{Tags.LIGHT_BLUE.wrap(Tags.BOLD.wrap("%crate_name%")), Tags.LIGHT_GRAY.wrap("Another hologram template."), Tags.LIGHT_GRAY.wrap("Edit templates in " + Tags.LIGHT_BLUE.wrap("config.yml"))}));
        map.put(template1.getId(), template1);
        map.put(template2.getId(), template2);
        return map;
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Text", this.text);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public List<String> getText() {
        return new ArrayList<String>(this.text);
    }
}

