/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.dialog.reward;

import java.util.ArrayList;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.reward.impl.ItemReward;
import su.nightexpress.excellentcrates.dialog.CrateDialog;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.ButtonLocale;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogActions;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardItemDialog
extends CrateDialog<Data> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Reward.Item.Title").text(RewardItemDialog.title("Reward", "Item"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Reward.Item.Body").dialogElement(400, new String[]{"Please select item save method.", "", TagWrappers.SOFT_RED.and((TagWrapper)TagWrappers.BOLD).wrap("IMPORTANT NOTE:"), "If the item above doesn't match the one you used, use the " + TagWrappers.SOFT_RED.wrap("Save as NBT") + " option.", TagWrappers.GRAY.wrap("This ensures the exact item data is saved correctly.")});
    private static final ButtonLocale BUTTON_NBT = LangEntry.builder((String)"Dialog.Reward.Item.Button.NBT").button((String)TagWrappers.SPRITE_NO_ATLAS.apply("item/" + BukkitThing.getValue((Keyed)Material.CREEPER_SPAWN_EGG)) + " Save as " + TagWrappers.SOFT_GREEN.wrap("NBT"));
    private static final ButtonLocale BUTTON_REFERENCE = LangEntry.builder((String)"Dialog.Reward.Item.Button.Reference").button((String)TagWrappers.SPRITE_NO_ATLAS.apply("item/" + BukkitThing.getValue((Keyed)Material.KNOWLEDGE_BOOK)) + " Save as " + TagWrappers.SOFT_GREEN.wrap("Reference"));
    private static final String JSON_NBT = "nbt";
    private static final String JSON_REFERENCE = "reference";

    public void show(@NotNull Player player, @NotNull ItemReward reward, @NotNull ItemStack itemStack, @Nullable Runnable callback) {
        this.show(player, new Data(reward, itemStack), callback);
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Data data) {
        ItemReward reward = data.reward;
        Crate crate = reward.getCrate();
        ItemStack itemStack = data.itemStack;
        AdaptedItem adaptedItem = ItemHelper.adapt(itemStack);
        ArrayList inputs = new ArrayList();
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.item((ItemStack)ItemHelper.toItemStack(adaptedItem)).build(), DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(inputs).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.action((ButtonLocale)BUTTON_NBT).action((WrappedDialogAction)DialogActions.customClick((String)JSON_NBT)).build(), DialogButtons.action((ButtonLocale)BUTTON_REFERENCE).action((WrappedDialogAction)DialogActions.customClick((String)JSON_REFERENCE)).build()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse(JSON_NBT, (viewer, identifier, nbtHolder) -> {
                AdaptedItem adapt = ItemHelper.adapt(itemStack, false);
                reward.addItem(adapt);
                crate.markDirty();
                viewer.callback();
            });
            builder.handleResponse(JSON_REFERENCE, (viewer, identifier, nbtHolder) -> {
                AdaptedItem adapt = ItemHelper.adapt(itemStack, true);
                reward.addItem(adapt);
                crate.markDirty();
                viewer.callback();
            });
        });
    }

    public record Data(@NotNull ItemReward reward, @NotNull ItemStack itemStack) {
    }
}

