/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.api.item.ItemProvider;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.config.Keys;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class CrateUtils {
    public static final int REWARD_ITEMS_LIMIT = 27;
    private static final Map<Player, Crate> ASSIGN_BLOCK_MAP = new WeakHashMap<Player, Crate>();

    public static void setAssignBlockCrate(@NotNull Player player, @NotNull Crate crate) {
        ASSIGN_BLOCK_MAP.put(player, crate);
    }

    @Nullable
    public static Crate getAssignBlockCrate(@NotNull Player player) {
        return ASSIGN_BLOCK_MAP.remove(player);
    }

    @NotNull
    public static Set<Player> getPlayersForEffects(@NotNull Location location) {
        HashSet<Player> players = new HashSet<Player>(Bukkit.getServer().getOnlinePlayers());
        players.removeIf(player -> !CrateUtils.isInEffectRange(player, location));
        return players;
    }

    public static boolean isInEffectRange(@NotNull Player player, @NotNull Location location) {
        World world = location.getWorld();
        int distance = (Integer)Config.CRATE_EFFECTS_VISIBILITY_DISTANCE.get();
        return player.getWorld() == world && player.getLocation().distance(location) <= (double)distance;
    }

    @NotNull
    public static ItemStack removeCrateTags(@NotNull ItemStack itemStack) {
        ItemUtil.editMeta((ItemStack)itemStack, meta -> {
            PDCUtil.remove((PersistentDataHolder)meta, (NamespacedKey)Keys.crateId);
            PDCUtil.remove((PersistentDataHolder)meta, (NamespacedKey)Keys.keyId);
        });
        return itemStack;
    }

    @NotNull
    public static String createID(@NotNull String name) {
        String id = StringUtil.transformForID((String)name);
        if (id.isBlank()) {
            id = UUID.randomUUID().toString().substring(0, 8);
        }
        return id;
    }

    @NotNull
    public static String generateRewardID(@NotNull Crate crate, @NotNull ItemProvider provider) {
        String itemName = CrateUtils.createID(provider.getItemType());
        int count = 0;
        while (crate.getReward(CrateUtils.addCount(itemName, count)) != null) {
            ++count;
        }
        return CrateUtils.addCount(itemName, count);
    }

    private static String addCount(@NotNull String str, int count) {
        return count <= 0 ? str : str + "_" + count;
    }

    public static boolean isSupportedParticle(@NotNull Particle particle) {
        return particle != Particle.VIBRATION && particle != Particle.DUST_COLOR_TRANSITION && particle != Particle.TRAIL;
    }

    public static boolean isSupportedParticleData(@NotNull UniParticle particle) {
        return particle.getParticle() != null && CrateUtils.isSupportedParticleData(particle.getParticle().getDataType());
    }

    public static boolean isSupportedParticleData(@NotNull Class<?> clazz) {
        return clazz != Void.class && clazz != Vibration.class && clazz != Particle.DustTransition.class && clazz != Particle.Trail.class;
    }
}

