/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening.selectable;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.opening.selectable.SelectableOpening;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.bridge.wrap.NightSound;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.ItemHandler;
import su.nightexpress.nightcore.ui.menu.item.ItemOptions;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.sound.VanillaSound;
import su.nightexpress.nightcore.util.text.tag.Tags;

public class SelectableMenu
extends LinkedMenu<CratesPlugin, SelectableOpening>
implements ConfigBased,
Filled<Reward> {
    private int[] rewardSlots;
    private String rewardName;
    private List<String> rewardLore;
    private String rewardEntry;
    private NightItem selectedIcon;
    private NightSound selectSound;
    private NightSound unselectSound;
    private NightSound limitSound;
    private NightSound confirmSound;

    public SelectableMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X6, Tags.BLACK.wrap("Select %amount% reward(s)!"));
    }

    @NotNull
    public MenuFiller<Reward> createFiller(@NotNull MenuViewer viewer) {
        Player player = viewer.getPlayer();
        SelectableOpening opening = (SelectableOpening)this.getLink(player);
        return MenuFiller.builder((Filled)this).setSlots(this.rewardSlots).setItems(opening.getRewards()).setItemCreator(reward -> {
            NightItem item = opening.isSelectedReward((Reward)reward) ? this.selectedIcon.copy() : NightItem.fromItemStack((ItemStack)reward.getPreviewItem()).setDisplayName(this.rewardName).setLore(this.rewardLore);
            return item.replacement(replacer -> replacer.replace(reward.replacePlaceholders()));
        }).setItemClick(reward -> (viewer1, event) -> {
            if (opening.isSelectedReward((Reward)reward)) {
                opening.removeSelectedReward((Reward)reward);
                this.unselectSound.play(player);
            } else {
                if (opening.isAllRewardsSelected()) {
                    this.limitSound.play(player);
                    return;
                }
                opening.addSelectedReward((Reward)reward);
                this.selectSound.play(player);
            }
            this.runNextTick(() -> this.flush(viewer));
        }).build();
    }

    @NotNull
    protected String getTitle(@NotNull MenuViewer viewer) {
        Player player = viewer.getPlayer();
        SelectableOpening opening = (SelectableOpening)this.getLink(player);
        return Replacer.create().replace("%amount%", () -> String.valueOf(opening.getRequiredAmount())).replace("%current%", () -> String.valueOf(opening.getSelectedAmount())).apply(super.getTitle(viewer));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    protected void onItemPrepare(@NotNull MenuViewer viewer, @NotNull MenuItem menuItem, @NotNull NightItem item) {
        super.onItemPrepare(viewer, menuItem, item);
        if (!viewer.hasItem(menuItem)) {
            SelectableOpening opening = (SelectableOpening)this.getLink(viewer);
            item.replacement(replacer -> replacer.replace("%amount%", () -> String.valueOf(opening.getRequiredAmount())).replace("%current%", () -> String.valueOf(opening.getSelectedAmount())).replace("%rewards%", () -> opening.getSelectedRewards().stream().sorted(Comparator.comparing(Reward::getId)).map(reward -> Replacer.create().replace(reward.replacePlaceholders()).apply(this.rewardEntry)).collect(Collectors.joining(Placeholders.TAG_LINE_BREAK))));
        }
    }

    protected void onClose(@NotNull MenuViewer viewer) {
        SelectableOpening opening = (SelectableOpening)this.getLink(viewer);
        boolean hasAnchor = this.cache.hasAnchor(viewer.getPlayer());
        super.onClose(viewer);
        if (!hasAnchor && !opening.isCompleted()) {
            opening.stop();
        }
    }

    private void handleConfirm(@NotNull MenuViewer viewer) {
        Player player = viewer.getPlayer();
        SelectableOpening opening = (SelectableOpening)this.getLink(player);
        opening.confirm();
        this.confirmSound.play(player);
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        this.rewardSlots = (int[])ConfigValue.create((String)"Reward.Slots", (int[])new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34}, (String[])new String[0]).read(config);
        this.rewardName = (String)ConfigValue.create((String)"Reward.Name", (String)"%reward_name%", (String[])new String[0]).read(config);
        this.rewardLore = (List)ConfigValue.create((String)"Reward.Lore", (List)Lists.newList((Object[])new String[]{"%reward_description%", "%empty-if-above%", Tags.LIGHT_YELLOW.wrap("\u2192 " + Tags.UNDERLINED.wrap("Click to select"))}), (String[])new String[0]).read(config);
        this.rewardEntry = (String)ConfigValue.create((String)"Reward.EntryName", (String)Tags.GRAY.wrap("- %reward_name%"), (String[])new String[0]).read(config);
        this.selectedIcon = (NightItem)ConfigValue.create((String)"Selection.Icon", (NightItem)NightItem.fromType((Material)Material.LIME_STAINED_GLASS_PANE).setDisplayName(Tags.GREEN.wrap(Tags.BOLD.wrap("Selected: ")) + Tags.WHITE.wrap("%reward_name%")).setLore(Lists.newList((Object[])new String[]{Tags.GRAY.wrap("You'll get this reward."), "", Tags.GREEN.wrap("\u2192 " + Tags.UNDERLINED.wrap("Click to unselect"))})).hideAllComponents(), (String[])new String[0]).read(config);
        this.selectSound = (NightSound)ConfigValue.create((String)"Selection.Sound-V", (NightSound)VanillaSound.of((Sound)Sound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE), (String[])new String[0]).read(config);
        this.unselectSound = (NightSound)ConfigValue.create((String)"Selection.Sound-X", (NightSound)VanillaSound.of((Sound)Sound.BLOCK_GLASS_BREAK), (String[])new String[0]).read(config);
        this.limitSound = (NightSound)ConfigValue.create((String)"Selection.Sound-Limit", (NightSound)VanillaSound.of((Sound)Sound.ENTITY_VILLAGER_NO), (String[])new String[0]).read(config);
        this.confirmSound = (NightSound)ConfigValue.create((String)"Selection.Sound-Confirm", (NightSound)VanillaSound.of((Sound)Sound.BLOCK_VAULT_OPEN_SHUTTER), (String[])new String[0]).read(config);
        loader.addDefaultItem(new NightItem(Material.BLACK_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setSlots(IntStream.range(45, 54).toArray()));
        loader.addDefaultItem(MenuItem.buildNextPage((Menu)this, (int)53).setPriority(10));
        loader.addDefaultItem(MenuItem.buildPreviousPage((Menu)this, (int)45).setPriority(10));
        loader.addDefaultItem(NightItem.fromType((Material)Material.LIME_DYE).setDisplayName(Tags.GREEN.wrap(Tags.BOLD.wrap("Confirm"))).setLore(Lists.newList((Object[])new String[]{Tags.GRAY.wrap("You'll get the following rewards:"), "%rewards%", "%empty-if-above%", Tags.GREEN.wrap("\u2192 " + Tags.UNDERLINED.wrap("Click to confirm"))})).hideAllComponents().toMenuItem().setSlots(new int[]{49}).setPriority(10).setHandler(new ItemHandler("confirm", (viewer, event) -> this.handleConfirm(viewer), ItemOptions.builder().setVisibilityPolicy(viewer -> ((SelectableOpening)this.getLink((MenuViewer)viewer)).isAllRewardsSelected()).build())));
        loader.addDefaultItem(NightItem.fromType((Material)Material.GRAY_DYE).setDisplayName(Tags.WHITE.wrap(Tags.BOLD.wrap("Confirm")) + " " + Tags.GRAY.wrap("(Not Enough)")).setLore(Lists.newList((Object[])new String[]{Tags.GRAY.wrap("You selected " + Tags.WHITE.wrap("%current%") + "/" + Tags.WHITE.wrap("%amount%") + " rewards."), "", Tags.WHITE.wrap("\u2192 " + Tags.UNDERLINED.wrap("Click to exit"))})).hideAllComponents().toMenuItem().setSlots(new int[]{49}).setPriority(1).setHandler(ItemHandler.forClose((Menu)this)));
    }
}

