/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.opening.Opening;
import su.nightexpress.excellentcrates.api.opening.OpeningProvider;
import su.nightexpress.excellentcrates.api.opening.ProviderLoader;
import su.nightexpress.excellentcrates.api.opening.ProviderSupplier;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.opening.OpeningListener;
import su.nightexpress.excellentcrates.opening.OpeningUtils;
import su.nightexpress.excellentcrates.opening.ProviderRegistry;
import su.nightexpress.excellentcrates.opening.world.provider.DummyProvider;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.FileUtil;

public class OpeningManager
extends AbstractManager<CratesPlugin> {
    private final Map<String, OpeningProvider> providerByIdMap = new HashMap<String, OpeningProvider>();
    private final Map<UUID, Opening> openingByPlayerMap = new ConcurrentHashMap<UUID, Opening>();
    private final DummyProvider dummyProvider;

    public OpeningManager(@NotNull CratesPlugin plugin) {
        super((NightCorePlugin)plugin);
        this.dummyProvider = new DummyProvider(plugin);
    }

    protected void onLoad() {
        this.loadDefaults();
        this.loadProviders();
        this.addListener((SimpeListener)new OpeningListener((CratesPlugin)this.plugin, this));
        this.addTask(this::tickOpenings, 1L);
    }

    protected void onShutdown() {
        this.getOpenings().forEach(Opening::stop);
        this.providerByIdMap.clear();
        this.openingByPlayerMap.clear();
    }

    @NotNull
    private String getDirectoryPath(@NotNull String dirName) {
        return String.valueOf(((CratesPlugin)this.plugin).getDataFolder()) + dirName;
    }

    private void loadDefaults() {
        File dir = new File(this.getDirectoryPath("/openings/"));
        if (dir.exists()) {
            return;
        }
        this.loadProvider("csgo", "/openings/inventory/", OpeningUtils::setupCSGO);
        this.loadProvider("enclosing", "/openings/inventory/", OpeningUtils::setupEnclosing);
        this.loadProvider("mystery", "/openings/inventory/", OpeningUtils::setupMystery);
        this.loadProvider("roulette", "/openings/inventory/", OpeningUtils::setupRoulette);
        this.loadProvider("storm", "/openings/inventory/", OpeningUtils::setupStorm);
        this.loadProvider("simple_roll", "/openings/simple_roll/", OpeningUtils::createSimpleRoll);
        this.loadProvider("selective_1", "/openings/selectable/", OpeningUtils::createSelectableSingle);
        this.loadProvider("selective_3", "/openings/selectable/", OpeningUtils::createSelectableTriple);
    }

    public void loadProviders() {
        for (ProviderLoader loader : ProviderRegistry.getLoaders()) {
            this.loadProviders(loader);
        }
        for (OpeningProvider provider : ProviderRegistry.getProviders()) {
            this.loadProvider(provider);
        }
        ((CratesPlugin)this.plugin).info("Loaded " + this.providerByIdMap.size() + " crate openings.");
    }

    public void loadProviders(@NotNull ProviderLoader loader) {
        String dirName = loader.getDirectory();
        ProviderSupplier supplier = loader.getSupplier();
        for (File file : FileUtil.getConfigFiles((String)this.getDirectoryPath(dirName))) {
            this.loadProvider(file, supplier);
        }
    }

    public void loadProvider(@NotNull String id, @NotNull String dirName, @NotNull ProviderSupplier supplier) {
        File file = new File(this.getDirectoryPath(dirName), FileConfig.withExtension((String)id));
        this.loadProvider(file, supplier);
    }

    public void loadProvider(@NotNull File file, @NotNull ProviderSupplier supplier) {
        FileConfig config = new FileConfig(file);
        String name = FileConfig.getName((File)file);
        OpeningProvider provider = supplier.supply((CratesPlugin)this.plugin, name);
        provider.load(config);
        config.saveChanges();
        this.loadProvider(provider);
    }

    public void loadProvider(@NotNull OpeningProvider provider) {
        this.providerByIdMap.put(provider.getId(), provider);
    }

    @NotNull
    public Map<String, OpeningProvider> getProviderByIdMap() {
        return this.providerByIdMap;
    }

    @NotNull
    public Set<OpeningProvider> getProviders() {
        return new HashSet<OpeningProvider>(this.providerByIdMap.values());
    }

    @NotNull
    public Set<String> getProviderIds() {
        return new HashSet<String>(this.providerByIdMap.keySet());
    }

    @Nullable
    public OpeningProvider getProviderById(@NotNull String id) {
        return this.providerByIdMap.get(id.toLowerCase());
    }

    @NotNull
    public Map<UUID, Opening> getOpeningByPlayerIdMap() {
        return this.openingByPlayerMap;
    }

    @NotNull
    public Set<Opening> getOpenings() {
        return new HashSet<Opening>(this.openingByPlayerMap.values());
    }

    @Nullable
    public Opening getOpening(@NotNull Player player) {
        return this.openingByPlayerMap.get(player.getUniqueId());
    }

    public void tickOpenings() {
        this.getOpenings().forEach(Opening::tick);
    }

    public boolean isOpening(@NotNull Player player) {
        return this.getOpening(player) != null;
    }

    public void stopOpening(@NotNull Player player) {
        Opening opening = this.removeOpening(player);
        if (opening == null) {
            return;
        }
        opening.stop();
    }

    @Nullable
    public Opening removeOpening(@NotNull Player player) {
        return this.openingByPlayerMap.remove(player.getUniqueId());
    }

    public boolean isOpeningAvailable(@NotNull Player player, @NotNull CrateSource source) {
        return !this.isOpening(player);
    }

    @NotNull
    public Opening createOpening(@NotNull Player player, @NotNull CrateSource source, @Nullable CrateKey key) {
        Crate crate = source.getCrate();
        OpeningProvider provider = null;
        if (crate.isAnimationEnabled()) {
            provider = this.getProviderById(crate.getAnimationId());
        }
        if (provider == null) {
            provider = this.dummyProvider;
        }
        return provider.createOpening(player, source, key);
    }

    public void startOpening(@NotNull Player player, @NotNull Opening opening, boolean instaRoll) {
        this.openingByPlayerMap.putIfAbsent(player.getUniqueId(), opening);
        opening.start();
        if (instaRoll) {
            opening.instaRoll();
        }
    }
}

