/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.item.provider.impl;

import org.bukkit.Keyed;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.api.item.ItemType;
import su.nightexpress.excellentcrates.item.provider.AbstractItemProvider;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.ItemNbt;
import su.nightexpress.nightcore.util.ItemTag;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.text.NightMessage;

public class VanillaItemProvider
extends AbstractItemProvider {
    private final ItemStack itemStack;

    public VanillaItemProvider(@NotNull ItemStack itemStack) {
        super(ItemType.VANILLA);
        this.itemStack = new ItemStack(itemStack);
    }

    @NotNull
    public static VanillaItemProvider fromItem(@NotNull ItemStack itemStack) {
        return new VanillaItemProvider(itemStack);
    }

    @Nullable
    public static VanillaItemProvider read(@NotNull FileConfig config, @NotNull String path) {
        ItemStack itemStack;
        ItemTag tag;
        String itemTag = config.getString(path + ".ItemTag");
        if (itemTag != null) {
            tag = new ItemTag(itemTag, Version.MC_1_21_4.getDataVersion());
            config.set(path + ".Tag", (Object)tag);
            config.remove(path + ".ItemTag");
        }
        if ((itemStack = ItemNbt.fromTag((ItemTag)(tag = ItemTag.read((FileConfig)config, (String)(path + ".Tag"))))) == null) {
            return null;
        }
        return new VanillaItemProvider(itemStack);
    }

    @Override
    public void writeAdditional(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Tag", (Object)ItemNbt.getTag((ItemStack)this.itemStack));
    }

    @Override
    public boolean isValid() {
        return !this.itemStack.getType().isAir();
    }

    @Override
    @Nullable
    public ItemStack createItemStack() {
        return new ItemStack(this.itemStack);
    }

    @Override
    @NotNull
    public String getItemType() {
        String display = StringUtil.transformForID((String)NightMessage.stripTags((String)ItemUtil.getSerializedName((ItemStack)this.itemStack)));
        if (!display.isBlank()) {
            return display;
        }
        return BukkitThing.toString((Keyed)this.itemStack.getType());
    }
}

