/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.api.item.ItemProvider;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.reward.impl.ItemReward;
import su.nightexpress.excellentcrates.item.ItemTypes;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.click.ClickResult;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class RewardContentMenu
extends LinkedMenu<CratesPlugin, ItemReward> {
    public RewardContentMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_REWARD_CONTENT.getString());
        this.addItem(NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setPriority(-1).setSlots(IntStream.range(0, 9).toArray()));
        this.addItem(NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setPriority(-1).setSlots(IntStream.range(36, 45).toArray()));
        this.addItem(MenuItem.buildReturn((Menu)this, (int)40, (viewer, event) -> this.runNextTick(() -> plugin.getEditorManager().openRewardOptions(viewer.getPlayer(), (Reward)this.getLink(viewer)))));
    }

    public void onClick(@NotNull MenuViewer viewer, @NotNull ClickResult result, @NotNull InventoryClickEvent event) {
        super.onClick(viewer, result, event);
        ItemStack clicked = result.getItemStack();
        if (clicked == null || clicked.getType().isAir()) {
            return;
        }
        Player player = viewer.getPlayer();
        ItemStack copy = new ItemStack(clicked);
        ItemReward reward = (ItemReward)this.getLink(viewer);
        if (result.isInventory()) {
            if (!ItemTypes.isCustom(copy)) {
                this.addItem(reward, ItemTypes.vanilla(copy));
                this.runNextTick(() -> this.flush(viewer));
            } else {
                this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openItemTypeMenu(player, copy, provider -> {
                    this.addItem(reward, (ItemProvider)provider);
                    this.runNextTick(() -> this.open(player, reward));
                }));
            }
        } else {
            int slot = result.getSlot();
            if (slot < 9 || slot > 27) {
                return;
            }
            Players.addItem((Player)player, (ItemStack[])new ItemStack[]{copy});
            if (event.isRightClick()) {
                return;
            }
            int index = slot - 9;
            reward.getItems().remove(index);
            reward.getCrate().saveReward(reward);
            this.runNextTick(() -> this.flush(viewer));
        }
        clicked.setAmount(0);
    }

    private void addItem(@NotNull ItemReward reward, @NotNull ItemProvider provider) {
        reward.addItem(provider);
        reward.getCrate().saveReward(reward);
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
    }

    public void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
        List<ItemProvider> items = ((ItemReward)this.getLink(viewer)).getItems();
        for (int index = 0; index < 27 && index < items.size(); ++index) {
            int slot = index + 9;
            inventory.setItem(slot, items.get(index).getItemStack());
        }
    }
}

