/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.Comparator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.config.EditorLang;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.CrateManager;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.language.entry.LangString;
import su.nightexpress.nightcore.manager.AbstractFileData;
import su.nightexpress.nightcore.ui.dialog.Dialog;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class CrateListMenu
extends LinkedMenu<CratesPlugin, CrateManager>
implements Filled<Crate> {
    public CrateListMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_CRATE_LIST.getString());
        this.addItem(MenuItem.buildReturn((Menu)this, (int)39, (viewer, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openEditor(viewer.getPlayer()))));
        this.addItem(MenuItem.buildNextPage((Menu)this, (int)44));
        this.addItem(MenuItem.buildPreviousPage((Menu)this, (int)36));
        this.addItem(Material.ANVIL, EditorLang.CRATE_CREATE, 41, (viewer, event, manager) -> this.handleInput(Dialog.builder((MenuViewer)viewer, (LangString)Lang.EDITOR_ENTER_CRATE_ID, input -> {
            if (!manager.create(input.getTextRaw())) {
                Lang.CRATE_CREATE_ERROR_DUPLICATED.getMessage().send((CommandSender)viewer.getPlayer());
                return false;
            }
            return true;
        })));
    }

    @NotNull
    public MenuFiller<Crate> createFiller(@NotNull MenuViewer viewer) {
        MenuFiller.Builder autoFill = MenuFiller.builder((Filled)this);
        autoFill.setSlots(IntStream.range(0, 36).toArray());
        autoFill.setItems(((CrateManager)((Object)this.getLink(viewer))).getCrates().stream().sorted(Comparator.comparing(AbstractFileData::getId)).toList());
        autoFill.setItemCreator(crate -> NightItem.fromItemStack((ItemStack)crate.getRawItem()).localized(EditorLang.CRATE_OBJECT).replacement(replacer -> replacer.replace(crate.replaceAllPlaceholders())));
        autoFill.setItemClick(crate -> (viewer1, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openOptionsMenu(viewer1.getPlayer(), (Crate)((Object)crate))));
        return autoFill.build();
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }
}

