/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.Collection;
import java.util.Comparator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.economybridge.EconomyBridge;
import su.nightexpress.economybridge.api.Currency;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.config.EditorLang;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.impl.Cost;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.language.entry.LangString;
import su.nightexpress.nightcore.ui.UIUtils;
import su.nightexpress.nightcore.ui.dialog.Dialog;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.confirmation.Confirmation;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class CrateCostsMenu
extends LinkedMenu<CratesPlugin, Crate>
implements Filled<Cost> {
    public CrateCostsMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_CRATE_OPEN_COSTS.getString());
        this.addItem(MenuItem.buildReturn((Menu)this, (int)39, (viewer, event) -> this.runNextTick(() -> plugin.getEditorManager().openOptionsMenu(viewer.getPlayer(), (Crate)((Object)((Object)((Object)this.getLink(viewer))))))));
        this.addItem(Material.ANVIL, EditorLang.CRATE_EDIT_OPEN_COST_CREATE, 41, (viewer, event, crate) -> this.handleInput(Dialog.builder((MenuViewer)viewer, (LangString)Lang.EDITOR_ENTER_CURRENCY, input -> {
            Currency currency = EconomyBridge.getCurrency((String)input.getTextRaw());
            if (currency == null) {
                return true;
            }
            crate.addOpenCost(new Cost(currency.getInternalId(), 0.0));
            crate.saveSettings();
            return true;
        }).setSuggestions((Collection)EconomyBridge.getCurrencyIds(), true)));
        this.addItem(MenuItem.buildNextPage((Menu)this, (int)44));
        this.addItem(MenuItem.buildPreviousPage((Menu)this, (int)36));
    }

    @NotNull
    public MenuFiller<Cost> createFiller(@NotNull MenuViewer viewer) {
        Player player = viewer.getPlayer();
        Crate crate = (Crate)((Object)this.getLink(player));
        MenuFiller.Builder autoFill = MenuFiller.builder((Filled)this);
        autoFill.setSlots(IntStream.range(0, 36).toArray());
        autoFill.setItems(((Crate)((Object)this.getLink(viewer))).getOpenCosts().stream().sorted(Comparator.comparing(Cost::getCurrencyId)).toList());
        autoFill.setItemCreator(cost -> {
            Currency currency = EconomyBridge.getCurrency((String)cost.getCurrencyId());
            NightItem item = currency == null ? NightItem.fromType((Material)Material.BARRIER) : NightItem.fromItemStack((ItemStack)currency.getIcon());
            String currencyId = cost.getCurrencyId();
            String amountStr = NumberUtil.format((double)cost.getAmount());
            item.localized(EditorLang.CRATE_EDIT_OPEN_COST_OBJECT);
            item.hideAllComponents();
            item.replacement(replacer -> replacer.replace("%name%", (Object)cost.format()).replace("%id%", (Object)(currency == null ? Lang.badEntry((String)currencyId) : Lang.goodEntry((String)currencyId))).replace("%amount%", (Object)(cost.isValidAmount() ? Lang.goodEntry((String)amountStr) : Lang.badEntry((String)amountStr))));
            return item;
        });
        autoFill.setItemClick(cost -> (viewer1, event) -> {
            if (event.isRightClick()) {
                UIUtils.openConfirmation((Player)player, (Confirmation)Confirmation.builder().onAccept((viewer2, event1) -> {
                    crate.removeOpenCost((Cost)cost);
                    crate.saveSettings();
                }).onReturn((viewer2, event1) -> ((CratesPlugin)this.plugin).runTask(task -> ((CratesPlugin)this.plugin).getEditorManager().openCostsMenu(player, crate))).returnOnAccept(true).build());
                return;
            }
            this.handleInput(Dialog.builder((MenuViewer)viewer1, (LangString)Lang.EDITOR_ENTER_AMOUNT, input -> {
                cost.setAmount(input.asDoubleAbs(0.0));
                crate.saveSettings();
                return true;
            }));
        });
        return autoFill.build();
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }
}

