/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.limit;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.TimeUtil;

public class LimitValues {
    public static final int NEVER_RESET = -1;
    public static final int MIDNIGHT_RESET = -2;
    private boolean enabled;
    private int amount;
    private long resetTime;
    private int resetStep;

    public LimitValues(boolean enabled, int amount, long resetTime, int resetStep) {
        this.setEnabled(enabled);
        this.setAmount(amount);
        this.setResetTime(resetTime);
        this.setResetStep(resetStep);
    }

    @NotNull
    public static LimitValues unlimited() {
        return new LimitValues(false, -1, 0L, 1);
    }

    @NotNull
    public static LimitValues read(@NotNull FileConfig config, @NotNull String path) {
        boolean enabled = (Boolean)ConfigValue.create((String)(path + ".Enabled"), (boolean)false, (String[])new String[0]).read(config);
        int amount = (Integer)ConfigValue.create((String)(path + ".Amount"), (int)-1, (String[])new String[0]).read(config);
        long cooldown = (Long)ConfigValue.create((String)(path + ".Cooldown"), (long)0L, (String[])new String[0]).read(config);
        int cooldownStep = (Integer)ConfigValue.create((String)(path + ".CooldownStep"), (int)1, (String[])new String[0]).read(config);
        return new LimitValues(enabled, amount, cooldown, cooldownStep);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Enabled", (Object)this.enabled);
        config.set(path + ".Amount", (Object)this.amount);
        config.set(path + ".Cooldown", (Object)this.resetTime);
        config.set(path + ".CooldownStep", (Object)this.resetStep);
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return Placeholders.LIMIT_VALUES.replacer((Object)this);
    }

    public boolean isMidnight() {
        return this.resetTime == -2L;
    }

    public boolean isNeverReset() {
        return this.resetTime == -1L || this.resetTime == 0L;
    }

    public long generateResetTimestamp() {
        if (this.isNeverReset()) {
            return -1L;
        }
        LocalDateTime now = LocalDateTime.now();
        if (this.isMidnight()) {
            return TimeUtil.toEpochMillis((LocalDateTime)LocalDateTime.of(now.toLocalDate().plusDays(1L), LocalTime.MIDNIGHT));
        }
        return TimeUtil.toEpochMillis((LocalDateTime)now) + this.resetTime * 1000L;
    }

    public boolean isResetStep(int amount) {
        return amount % this.resetStep == 0;
    }

    public boolean isUnlimitedAmount() {
        return this.amount < 0;
    }

    public boolean isOneTimed() {
        return this.amount == 1;
    }

    public void setMidnightCooldown() {
        this.setResetTime(-2L);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public long getResetTime() {
        return this.resetTime;
    }

    public void setResetTime(long resetTime) {
        this.resetTime = resetTime;
    }

    public int getResetStep() {
        return this.resetStep;
    }

    public void setResetStep(int resetStep) {
        this.resetStep = Math.max(1, resetStep);
    }
}

