/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.effect;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.crate.effect.CrateEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.BeaconEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.DummyEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.HeartEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.HelixEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.PulsarEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.SimpleEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.SphereEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.SpiralEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.TornadoEffect;
import su.nightexpress.excellentcrates.crate.effect.impl.VortexEffect;

public class EffectRegistry {
    private static Map<String, CrateEffect> effectById;
    private static DummyEffect dummyEffect;

    public static void load() {
        effectById = new HashMap<String, CrateEffect>();
        dummyEffect = new DummyEffect();
        EffectRegistry.register("beacon", new BeaconEffect());
        EffectRegistry.register("heart", new HeartEffect());
        EffectRegistry.register("helix", new HelixEffect());
        EffectRegistry.register("pulsar", new PulsarEffect());
        EffectRegistry.register("simple", new SimpleEffect());
        EffectRegistry.register("sphere", new SphereEffect());
        EffectRegistry.register("spiral", new SpiralEffect());
        EffectRegistry.register("tornado", new TornadoEffect());
        EffectRegistry.register("vortex", new VortexEffect());
        EffectRegistry.register("none", dummyEffect);
    }

    public static void clear() {
        effectById.clear();
        effectById = null;
        dummyEffect = null;
    }

    public static void register(@NotNull String name, @NotNull CrateEffect effect) {
        effectById.put(name.toLowerCase(), effect);
    }

    @NotNull
    public static Set<CrateEffect> getEffects() {
        return new HashSet<CrateEffect>(effectById.values());
    }

    @NotNull
    public static Set<String> getEffectNames() {
        return new HashSet<String>(effectById.keySet());
    }

    @Nullable
    public static CrateEffect getEffectById(@NotNull String name) {
        return effectById.get(name.toLowerCase());
    }

    @NotNull
    public static CrateEffect getEffectOrDummy(@NotNull String name) {
        return effectById.getOrDefault(name.toLowerCase(), dummyEffect);
    }
}

