/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.api.event.CrateObtainRewardEvent;
import su.nightexpress.excellentcrates.api.event.CrateOpenEvent;
import su.nightexpress.excellentcrates.api.opening.Opening;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.config.Keys;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.config.Perms;
import su.nightexpress.excellentcrates.crate.effect.CrateEffect;
import su.nightexpress.excellentcrates.crate.effect.EffectRegistry;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.crate.impl.Milestone;
import su.nightexpress.excellentcrates.crate.impl.OpenSettings;
import su.nightexpress.excellentcrates.crate.impl.Rarity;
import su.nightexpress.excellentcrates.crate.listener.CrateListener;
import su.nightexpress.excellentcrates.crate.menu.MilestonesMenu;
import su.nightexpress.excellentcrates.crate.menu.PreviewMenu;
import su.nightexpress.excellentcrates.data.crate.GlobalCrateData;
import su.nightexpress.excellentcrates.data.crate.UserCrateData;
import su.nightexpress.excellentcrates.data.reward.RewardLimit;
import su.nightexpress.excellentcrates.hologram.HologramTemplate;
import su.nightexpress.excellentcrates.item.ItemTypes;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.user.CrateUser;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.excellentcrates.util.InteractType;
import su.nightexpress.excellentcrates.util.inspect.Inspectors;
import su.nightexpress.excellentcrates.util.pos.WorldPos;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.tag.Tags;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class CrateManager
extends AbstractManager<CratesPlugin> {
    private final Map<String, Rarity> rarityByIdMap = new HashMap<String, Rarity>();
    private final Map<String, Crate> crateByIdMap = new HashMap<String, Crate>();
    private final Map<WorldPos, Crate> crateByPosMap = new HashMap<WorldPos, Crate>();
    private final Map<String, PreviewMenu> previewByIdMap = new HashMap<String, PreviewMenu>();
    private final Map<UUID, Long> previewCooldown = new HashMap<UUID, Long>();
    private MilestonesMenu milestonesMenu;

    public CrateManager(@NotNull CratesPlugin plugin) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.updateHologramTemplates();
        this.loadRarities();
        this.loadPreviews();
        this.loadCrates();
        this.loadUI();
        ((CratesPlugin)this.plugin).runTask(task -> this.runInspections());
        this.addListener((SimpeListener)new CrateListener((CratesPlugin)this.plugin, this));
        this.addAsyncTask(this::playCrateEffects, 1L);
    }

    protected void onShutdown() {
        if (this.milestonesMenu != null) {
            this.milestonesMenu.clear();
        }
        this.previewByIdMap.values().forEach(LinkedMenu::clear);
        this.previewByIdMap.clear();
        this.crateByIdMap.clear();
        this.crateByPosMap.clear();
        this.rarityByIdMap.clear();
    }

    private void updateHologramTemplates() {
        FileConfig config = ((CratesPlugin)this.plugin).getConfig();
        if (!config.contains("Crate.Holograms.Templates")) {
            return;
        }
        config.remove("Crate.Holograms.TemplateList");
        config.getSection("Crate.Holograms.Templates").forEach(sId -> {
            List text = config.getStringList("Crate.Holograms.Templates." + sId);
            HologramTemplate template = new HologramTemplate((String)sId, text);
            template.write(config, "Crate.Holograms.TemplateList." + sId);
        });
        config.remove("Crate.Holograms.Templates");
        Config.CRATE_HOLOGRAM_TEMPLATES.read(config);
    }

    private void loadRarities() {
        FileConfig config = ((CratesPlugin)this.plugin).getConfig();
        if (config.getSection("Rewards.Rarities").isEmpty()) {
            HashSet<Rarity> rarities = new HashSet<Rarity>();
            File oldFile = new File(((CratesPlugin)this.plugin).getDataFolder(), "rarity.yml");
            if (oldFile.exists()) {
                FileConfig oldConfig = new FileConfig(oldFile);
                for (String id : oldConfig.getSection("")) {
                    rarities.add(Rarity.read((CratesPlugin)this.plugin, oldConfig, id, id));
                }
                oldFile.delete();
            }
            if (rarities.isEmpty()) {
                rarities.add(new Rarity((CratesPlugin)this.plugin, "common", Tags.WHITE.wrap("Common"), 70.0));
                rarities.add(new Rarity((CratesPlugin)this.plugin, "rare", Tags.LIGHT_GREEN.wrap("Rare"), 25.0));
                rarities.add(new Rarity((CratesPlugin)this.plugin, "mythic", Tags.LIGHT_PURPLE.wrap("Mythic"), 5.0));
            }
            rarities.forEach(rarity -> rarity.write(config, "Rewards.Rarities." + rarity.getId()));
        }
        config.getSection("Rewards.Rarities").forEach(rarityId -> {
            Rarity rarity = Rarity.read((CratesPlugin)this.plugin, config, "Rewards.Rarities." + rarityId, rarityId);
            this.rarityByIdMap.put(rarity.getId(), rarity);
        });
        ((CratesPlugin)this.plugin).info("Loaded " + this.rarityByIdMap.size() + " rarities!");
    }

    private void loadPreviews() {
        File dir = new File(((CratesPlugin)this.plugin).getDataFolder().getAbsolutePath(), "/previews/");
        if (!dir.exists() && dir.mkdirs()) {
            new PreviewMenu((CratesPlugin)this.plugin, FileConfig.loadOrExtract((NightCorePlugin)this.plugin, (String)"/previews/", (String)"default.yml"));
        }
        for (FileConfig config : FileConfig.loadAll((String)(String.valueOf(((CratesPlugin)this.plugin).getDataFolder()) + "/previews/"), (boolean)false)) {
            PreviewMenu menu = new PreviewMenu((CratesPlugin)this.plugin, config);
            String id = config.getFile().getName().replace(".yml", "").toLowerCase();
            this.previewByIdMap.put(id, menu);
        }
    }

    private void loadUI() {
        if (Config.isMilestonesEnabled()) {
            this.milestonesMenu = new MilestonesMenu((CratesPlugin)this.plugin);
        }
    }

    private void loadCrates() {
        for (File file : FileUtil.getFiles((String)(String.valueOf(((CratesPlugin)this.plugin).getDataFolder()) + "/crates/"), (boolean)false)) {
            Crate crate = new Crate((CratesPlugin)this.plugin, file);
            this.loadCrate(crate);
        }
        ((CratesPlugin)this.plugin).info("Loaded " + this.crateByIdMap.size() + " crates.");
    }

    private void loadCrate(@NotNull Crate crate) {
        if (crate.load()) {
            this.crateByIdMap.put(crate.getId(), crate);
            this.addCratePositions(crate);
        } else {
            ((CratesPlugin)this.plugin).error("Crate not loaded: '" + crate.getFile().getName() + "'.");
        }
    }

    private void runInspections() {
        this.getCrates().forEach(crate -> {
            String filePath = crate.getFile().getPath();
            Inspectors.CRATE.printConsole((CratesPlugin)this.plugin, (Crate)((Object)crate), "Problems in '" + crate.getId() + "' crate (" + filePath + "):");
            crate.getRewards().forEach(reward -> Inspectors.REWARD.printConsole((CratesPlugin)this.plugin, (Reward)reward, "Problems in '" + reward.getId() + "' reward (" + filePath + "):"));
        });
    }

    @NotNull
    public Map<String, Rarity> getRarityByIdMap() {
        return this.rarityByIdMap;
    }

    @NotNull
    public Set<Rarity> getRarities() {
        return new HashSet<Rarity>(this.rarityByIdMap.values());
    }

    @Nullable
    public Rarity getRarity(@NotNull String id) {
        return this.rarityByIdMap.get(id.toLowerCase());
    }

    @NotNull
    public Set<String> getRarityIds() {
        return new HashSet<String>(this.rarityByIdMap.keySet());
    }

    @NotNull
    public Rarity getMostCommonRarity() {
        return this.getRarities().stream().max(Comparator.comparing(Rarity::getWeight)).orElseThrow();
    }

    @NotNull
    public Map<String, PreviewMenu> getPreviewByIdMap() {
        return this.previewByIdMap;
    }

    @Nullable
    public PreviewMenu getPreviewById(@NotNull String id) {
        return this.previewByIdMap.get(id.toLowerCase());
    }

    @NotNull
    public Set<PreviewMenu> getPreviews() {
        return new HashSet<PreviewMenu>(this.previewByIdMap.values());
    }

    @NotNull
    public List<String> getPreviewNames() {
        return new ArrayList<String>(this.previewByIdMap.keySet());
    }

    public void openMilestones(@NotNull Player player, @NotNull CrateSource source) {
        if (this.milestonesMenu != null) {
            this.milestonesMenu.open(player, source);
        }
    }

    @NotNull
    public List<String> getCrateIds() {
        return new ArrayList<String>(this.crateByIdMap.keySet());
    }

    @NotNull
    public Map<String, Crate> getCratesMap() {
        return this.crateByIdMap;
    }

    @NotNull
    public Set<Crate> getCrates() {
        return new HashSet<Crate>(this.crateByIdMap.values());
    }

    public boolean isCrate(@NotNull ItemStack item) {
        return this.getCrateByItem(item) != null;
    }

    @Nullable
    public Crate getCrateById(@NotNull String id) {
        return this.crateByIdMap.get(id.toLowerCase());
    }

    @Nullable
    public Crate getCrateByItem(@NotNull ItemStack item) {
        String id = PDCUtil.getString((ItemStack)item, (NamespacedKey)Keys.crateId).orElse(null);
        return id != null ? this.getCrateById(id) : null;
    }

    @Nullable
    public Crate getCrateByBlock(@NotNull Block block) {
        return this.getCrateByLocation(block.getLocation());
    }

    @Nullable
    public Crate getCrateByLocation(@NotNull Location location) {
        WorldPos pos = WorldPos.from(location);
        return this.crateByPosMap.get(pos);
    }

    public void removeCratePositions(@NotNull Crate crate) {
        crate.getBlockPositions().forEach(this.crateByPosMap::remove);
    }

    public void addCratePositions(@NotNull Crate crate) {
        crate.getBlockPositions().forEach(pos -> this.crateByPosMap.put((WorldPos)pos, crate));
    }

    public boolean create(@NotNull String id) {
        if (this.getCrateById(id = CrateUtils.createID(id)) != null) {
            return false;
        }
        File file = new File(String.valueOf(((CratesPlugin)this.plugin).getDataFolder()) + "/crates/", id + ".yml");
        FileUtil.create((File)file);
        String name = StringUtil.capitalizeUnderscored((String)id) + " Crate";
        ItemStack item = NightItem.asCustomHead((String)"1ff041976a09dd053e3d1d4e611aac09594d74fc71a0ec4da0110416d317dba8").setDisplayName(name).hideAllComponents().getItemStack();
        Crate crate = new Crate((CratesPlugin)this.plugin, file);
        crate.setName(name);
        crate.setDescription(new ArrayList<String>());
        crate.setItemProvider(ItemTypes.vanilla(item));
        crate.setAnimationEnabled(true);
        crate.setAnimationId("default");
        crate.setPreviewEnabled(true);
        crate.setPreviewId("default");
        crate.setPushbackEnabled(true);
        crate.setHologramEnabled(true);
        crate.setHologramTemplateId("default");
        crate.setEffectType("helix");
        crate.setEffectParticle(UniParticle.of((Particle)Particle.CLOUD));
        crate.save();
        this.loadCrate(crate);
        return true;
    }

    public boolean delete(@NotNull Crate crate) {
        if (!crate.getFile().delete()) {
            return false;
        }
        crate.removeHologram();
        ((CratesPlugin)this.plugin).getDataManager().handleCrateRemoval(crate);
        this.crateByIdMap.remove(crate.getId());
        this.crateByPosMap.values().removeIf(stored -> stored == crate);
        return true;
    }

    public boolean dropCrateItem(@NotNull Crate crate, @NotNull Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        world.dropItemNaturally(location, crate.getItem());
        return true;
    }

    public void giveCrateItem(@NotNull Player player, @NotNull Crate crate, int amount) {
        amount = Math.max(1, amount);
        ItemStack crateItem = crate.getItem();
        Players.addItem((Player)player, (ItemStack)crateItem, (int)amount);
    }

    public void previewCrate(@NotNull Player player, @NotNull CrateSource source) {
        Crate crate = source.getCrate();
        if (!crate.isPreviewEnabled()) {
            return;
        }
        PreviewMenu menu = this.getPreviewById(crate.getPreviewId());
        if (menu == null) {
            return;
        }
        menu.open(player, source);
    }

    public void interactCrate(@NotNull Player player, @NotNull Crate crate, @NotNull InteractType action, @Nullable ItemStack item, @Nullable Block block) {
        CrateSource source = new CrateSource(crate, item, block);
        if (action == InteractType.CRATE_PREVIEW) {
            this.previewCrate(player, source);
            return;
        }
        if (action == InteractType.CRATE_OPEN || action == InteractType.CRATE_MASS_OPEN) {
            int massLimit;
            OpenSettings settings = new OpenSettings().setSkipAnimation(action == InteractType.CRATE_MASS_OPEN);
            int keys = ((CratesPlugin)this.plugin).getKeyManager().getKeysAmount(player, crate);
            int openings = action == InteractType.CRATE_MASS_OPEN && crate.isKeyRequired() ? Math.max(1, keys) : 1;
            if (openings > (massLimit = Math.max(1, (Integer)Config.CRATE_MASS_OPENING_LIMIT.get()))) {
                openings = massLimit;
            }
            for (int spent = 0; spent < openings; ++spent) {
                if (this.openCrate(player, source, settings)) continue;
                if (spent != 0 || block == null || !crate.isPushbackEnabled()) break;
                player.setVelocity(player.getEyeLocation().getDirection().setY(((Double)Config.CRATE_PUSHBACK_Y.get()).doubleValue()).multiply(((Double)Config.CRATE_PUSHBACK_MULTIPLY.get()).doubleValue()));
                break;
            }
        }
    }

    public boolean openCrate(@NotNull Player player, @NotNull CrateSource source, @NotNull OpenSettings settings) {
        if (!((CratesPlugin)this.plugin).getDataManager().isDataLoaded()) {
            return false;
        }
        if (!((CratesPlugin)this.plugin).getOpeningManager().isOpeningAvailable(player, source)) {
            Lang.CRATE_OPEN_ERROR_ALREADY.getMessage().send((CommandSender)player);
            return false;
        }
        if (source.getItem() != null && source.getItem().getAmount() <= 0) {
            return false;
        }
        Crate crate = source.getCrate();
        if (!settings.isForce() && !crate.hasPermission(player)) {
            Lang.ERROR_NO_PERMISSION.getMessage(this.plugin).send((CommandSender)player);
            return false;
        }
        if (!settings.isForce() && player.getInventory().firstEmpty() == -1) {
            Lang.CRATE_OPEN_ERROR_INVENTORY_SPACE.getMessage().send((CommandSender)player, replacer -> replacer.replace(crate.replacePlaceholders()));
            return false;
        }
        CrateKey key = null;
        CrateUser user = (CrateUser)((CratesPlugin)this.plugin).getUserManager().getOrFetch(player);
        UserCrateData crateData = user.getCrateData(crate);
        if (!settings.isForce() && crate.hasOpenCooldown() && crateData.hasCooldown()) {
            (crateData.isCooldownPermanent() ? Lang.CRATE_OPEN_ERROR_COOLDOWN_ONE_TIMED : Lang.CRATE_OPEN_ERROR_COOLDOWN_TEMPORARY).getMessage().send((CommandSender)player, replacer -> replacer.replace("%time%", (Object)TimeFormats.formatDuration((long)crateData.getOpenCooldown(), (TimeFormatType)TimeFormatType.LITERAL)).replace(crate.replacePlaceholders()));
            return false;
        }
        if (!settings.isForce() && crate.isKeyRequired() && (key = ((CratesPlugin)this.plugin).getKeyManager().getOpenKey(player, crate)) == null) {
            boolean holdRequired = Config.isKeyHoldRequired() && !crate.isAllVirtualKeys();
            (holdRequired ? Lang.CRATE_OPEN_ERROR_NO_HOLD_KEY : Lang.CRATE_OPEN_ERROR_NO_KEY).getMessage().send((CommandSender)player, replacer -> replacer.replace(crate.replacePlaceholders()));
            return false;
        }
        if (!settings.isForce() && !crate.canAffordOpen(player)) {
            Lang.CRATE_OPEN_ERROR_TOO_EXPENSIVE.getMessage().send((CommandSender)player, replacer -> replacer.replace(crate.replacePlaceholders()));
            return false;
        }
        if (crate.getRewards(player).isEmpty()) {
            Lang.CRATE_OPEN_ERROR_NO_REWARDS.getMessage().send((CommandSender)player, replacer -> replacer.replace(crate.replacePlaceholders()));
            return false;
        }
        CrateOpenEvent openEvent = new CrateOpenEvent(crate, player);
        ((CratesPlugin)this.plugin).getPluginManager().callEvent((Event)openEvent);
        if (openEvent.isCancelled()) {
            return false;
        }
        player.closeInventory();
        Opening opening = ((CratesPlugin)this.plugin).getOpeningManager().createOpening(player, source, key);
        opening.setRefundable(!settings.isForce());
        ((CratesPlugin)this.plugin).getOpeningManager().startOpening(player, opening, settings.isSkipAnimation());
        if (!settings.isForce()) {
            ItemStack item;
            crate.payForOpen(player);
            if (crate.isKeyRequired() && key != null) {
                ((CratesPlugin)this.plugin).getKeyManager().takeKey(player, key, 1);
            }
            if ((item = source.getItem()) != null) {
                item.setAmount(item.getAmount() - 1);
            }
        }
        return true;
    }

    public boolean triggerMilestones(@NotNull Player player, @NotNull Crate crate, int progress) {
        if (!crate.hasMilestones()) {
            return false;
        }
        int maxProgress = crate.getMaxMilestone();
        if (!crate.isMilestonesRepeatable() && progress > maxProgress) {
            return false;
        }
        Milestone milestone = crate.getMilestone(progress);
        if (milestone == null) {
            return false;
        }
        Reward reward = milestone.getReward();
        if (reward == null) {
            return false;
        }
        reward.giveContent(player);
        Lang.CRATE_OPEN_MILESTONE_COMPLETED.getMessage().send((CommandSender)player, replacer -> replacer.replace(crate.replacePlaceholders()).replace("%milestone_openings%", (Object)NumberUtil.format((double)progress)).replace(reward.replacePlaceholders()));
        return true;
    }

    public void giveReward(@NotNull Player player, @NotNull Reward reward) {
        reward.giveContent(player);
        Crate crate = reward.getCrate();
        GlobalCrateData globalData = ((CratesPlugin)this.plugin).getDataManager().getCrateDataOrCreate(crate);
        globalData.setLatestReward(reward);
        globalData.setSaveRequired(true);
        Lang.CRATE_OPEN_REWARD_INFO.getMessage().send((CommandSender)player, replacer -> replacer.replace(crate.replacePlaceholders()).replace(reward.replacePlaceholders()));
        if (reward.isBroadcast()) {
            Lang.CRATE_OPEN_REWARD_BROADCAST.getMessage().broadcast(replacer -> replacer.replace(Placeholders.forPlayerWithPAPI((Player)player)).replace(crate.replacePlaceholders()).replace(reward.replacePlaceholders()));
        }
        this.addRollCount(player, reward);
        ((CratesPlugin)this.plugin).getCrateLogger().logReward(player, reward);
        CrateObtainRewardEvent event = new CrateObtainRewardEvent(reward, player);
        ((CratesPlugin)this.plugin).getPluginManager().callEvent((Event)event);
    }

    public int getGlobalRollsLeft(@NotNull Reward reward) {
        if (!reward.hasGlobalLimit()) {
            return -1;
        }
        RewardLimit limit = ((CratesPlugin)this.plugin).getDataManager().getRewardLimit(reward, null);
        if (limit == null) {
            return reward.getGlobalLimits().getAmount();
        }
        limit.resetIfReady();
        return Math.max(0, reward.getGlobalLimits().getAmount() - limit.getAmount());
    }

    public int getPersonalRollsLeft(@NotNull Reward reward, @NotNull Player player) {
        if (!reward.hasPersonalLimit()) {
            return -1;
        }
        RewardLimit limit = ((CratesPlugin)this.plugin).getDataManager().getRewardLimit(reward, player);
        if (limit == null) {
            return reward.getPlayerLimits().getAmount();
        }
        limit.resetIfReady();
        return Math.max(0, reward.getPlayerLimits().getAmount() - limit.getAmount());
    }

    public int getAvailableRolls(@NotNull Player player, @NotNull Reward reward) {
        int globalLeft = this.getGlobalRollsLeft(reward);
        int playerLeft = this.getPersonalRollsLeft(reward, player);
        if (globalLeft < 0 || playerLeft < 0) {
            return Math.max(playerLeft, globalLeft);
        }
        return Math.min(playerLeft, globalLeft);
    }

    public void addRollCount(@NotNull Player player, @NotNull Reward reward) {
        RewardLimit limit;
        if (player.hasPermission((Permission)Perms.BYPASS_REWARD_LIMIT)) {
            return;
        }
        if (reward.hasGlobalLimit()) {
            limit = ((CratesPlugin)this.plugin).getDataManager().getRewardLimitOrCreate(reward, null);
            limit.resetIfReady();
            limit.addRoll(1);
            limit.updateResetTime(reward.getGlobalLimits());
            limit.setSaveRequired(true);
        }
        if (reward.hasPersonalLimit()) {
            limit = ((CratesPlugin)this.plugin).getDataManager().getRewardLimitOrCreate(reward, player);
            limit.resetIfReady();
            limit.addRoll(1);
            limit.updateResetTime(reward.getPlayerLimits());
            limit.setSaveRequired(true);
        }
    }

    public void setPreviewCooldown(@NotNull Player player) {
        long timestamp = System.currentTimeMillis() + (Long)Config.CRATE_PREVIEW_COOLDOWN.get();
        this.previewCooldown.put(player.getUniqueId(), timestamp);
    }

    public long getPreviewCooldown(@NotNull Player player) {
        long timestamp = this.previewCooldown.getOrDefault(player.getUniqueId(), 0L);
        if (System.currentTimeMillis() < timestamp) {
            return timestamp;
        }
        this.removePreviewCooldown(player);
        return 0L;
    }

    public boolean hasPreviewCooldown(@NotNull Player player) {
        return this.getPreviewCooldown(player) > 0L;
    }

    public void removePreviewCooldown(@NotNull Player player) {
        this.previewCooldown.remove(player.getUniqueId());
    }

    public void playCrateEffects() {
        this.getCrates().forEach(crate -> {
            CrateEffect effect = crate.getEffect();
            if (effect.isDummy()) {
                return;
            }
            UniParticle particle = crate.getEffectParticle();
            crate.getBlockPositions().forEach(worldPos -> {
                if (!worldPos.isChunkLoaded()) {
                    return;
                }
                Location location = worldPos.toLocation();
                if (location == null) {
                    return;
                }
                CrateUtils.getPlayersForEffects(location).forEach(player -> effect.playStep(location, particle, (Player)player));
            });
        });
        EffectRegistry.getEffects().forEach(CrateEffect::addTickCount);
    }
}

