/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.command.basic;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.excellentcrates.command.CommandArguments;
import su.nightexpress.excellentcrates.command.CommandFlags;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.config.Perms;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.crate.impl.OpenSettings;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.user.CrateUser;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.command.experimental.CommandContext;
import su.nightexpress.nightcore.command.experimental.TabContext;
import su.nightexpress.nightcore.command.experimental.argument.ArgumentTypes;
import su.nightexpress.nightcore.command.experimental.argument.ParsedArguments;
import su.nightexpress.nightcore.command.experimental.builder.ChainedNodeBuilder;
import su.nightexpress.nightcore.command.experimental.builder.DirectNodeBuilder;
import su.nightexpress.nightcore.command.experimental.builder.FlagBuilder;
import su.nightexpress.nightcore.command.experimental.builder.NodeBuilder;
import su.nightexpress.nightcore.command.experimental.impl.ReloadCommand;
import su.nightexpress.nightcore.command.experimental.node.ChainedNode;
import su.nightexpress.nightcore.command.experimental.node.DirectNode;
import su.nightexpress.nightcore.db.AbstractUser;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.wrapper.UniPermission;

public class BaseCommands {
    public static void load(@NotNull CratesPlugin plugin) {
        ChainedNode root = plugin.getRootNode();
        root.addChildren((NodeBuilder)ReloadCommand.builder((NightCorePlugin)plugin, (UniPermission)Perms.COMMAND_RELOAD));
        root.addChildren((NodeBuilder)((ChainedNodeBuilder)((ChainedNodeBuilder)ChainedNode.builder((NightCorePlugin)plugin, (String[])new String[]{"key"}).description(Lang.COMMAND_KEY_DESC)).permission(Perms.COMMAND_KEY)).addDirect("drop", builder -> ((DirectNodeBuilder)((DirectNodeBuilder)builder.description(Lang.COMMAND_DROP_KEY_DESC)).permission(Perms.COMMAND_DROP_KEY)).withArgument(CommandArguments.forKey(plugin).required()).withArgument(ArgumentTypes.decimal((String)"x").required().localized(Lang.COMMAND_ARGUMENT_NAME_X).withSamples(context -> BaseCommands.getCoords(context, Location::getBlockX))).withArgument(ArgumentTypes.decimal((String)"y").required().localized(Lang.COMMAND_ARGUMENT_NAME_Y).withSamples(context -> BaseCommands.getCoords(context, Location::getBlockY))).withArgument(ArgumentTypes.decimal((String)"z").required().localized(Lang.COMMAND_ARGUMENT_NAME_Z).withSamples(context -> BaseCommands.getCoords(context, Location::getBlockZ))).withArgument(ArgumentTypes.world((String)"world").required()).executes((context, arguments) -> BaseCommands.dropKey(plugin, context, arguments))).addDirect("inspect", builder -> ((DirectNodeBuilder)((DirectNodeBuilder)builder.description(Lang.COMMAND_KEY_INSPECT_DESC)).permission(Perms.COMMAND_KEY_INSPECT)).withArgument(ArgumentTypes.playerName((String)"player").permission(Perms.COMMAND_KEY_INSPECT_OTHERS)).executes((context, arguments) -> BaseCommands.inspectKeys(plugin, context, arguments))).addDirect("giveall", builder -> ((DirectNodeBuilder)((DirectNodeBuilder)builder.description(Lang.COMMAND_KEY_GIVE_ALL_DESC)).permission(Perms.COMMAND_KEY_GIVE)).withArgument(CommandArguments.forKey(plugin).required()).withArgument(ArgumentTypes.integerAbs((String)"amount").localized(Lang.COMMAND_ARGUMENT_NAME_AMOUNT).withSamples(context -> Lists.newList((Object[])new String[]{"1", "5", "10"}))).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentFeedback()).executes((context, arguments) -> BaseCommands.giveKeyAll(plugin, context, arguments))).addDirect("give", builder -> ((DirectNodeBuilder)((DirectNodeBuilder)BaseCommands.buildKeyManage(plugin, builder).description(Lang.COMMAND_KEY_GIVE_DESC)).permission(Perms.COMMAND_KEY_GIVE)).executes((context, arguments) -> BaseCommands.giveKey(plugin, context, arguments))).addDirect("set", builder -> ((DirectNodeBuilder)((DirectNodeBuilder)BaseCommands.buildKeyManage(plugin, builder).description(Lang.COMMAND_KEY_SET_DESC)).permission(Perms.COMMAND_KEY_SET)).executes((context, arguments) -> BaseCommands.setKey(plugin, context, arguments))).addDirect("take", builder -> ((DirectNodeBuilder)((DirectNodeBuilder)BaseCommands.buildKeyManage(plugin, builder).description(Lang.COMMAND_KEY_TAKE_DESC)).permission(Perms.COMMAND_KEY_TAKE)).executes((context, arguments) -> BaseCommands.takeKey(plugin, context, arguments))));
        root.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"drop"}).description(Lang.COMMAND_DROP_DESC)).permission(Perms.COMMAND_DROP)).withArgument(CommandArguments.forCrate(plugin).required()).withArgument(ArgumentTypes.decimal((String)"x").required().localized(Lang.COMMAND_ARGUMENT_NAME_X).withSamples(context -> BaseCommands.getCoords(context, Location::getBlockX))).withArgument(ArgumentTypes.decimal((String)"y").required().localized(Lang.COMMAND_ARGUMENT_NAME_Y).withSamples(context -> BaseCommands.getCoords(context, Location::getBlockY))).withArgument(ArgumentTypes.decimal((String)"z").required().localized(Lang.COMMAND_ARGUMENT_NAME_Z).withSamples(context -> BaseCommands.getCoords(context, Location::getBlockZ))).withArgument(ArgumentTypes.world((String)"world").required()).executes((context, arguments) -> BaseCommands.dropCrate(plugin, context, arguments)));
        root.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"editor"}).description(Lang.COMMAND_EDITOR_DESC)).permission(Perms.COMMAND_EDITOR)).playerOnly()).executes((context, arguments) -> BaseCommands.openEditor(plugin, context)));
        root.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"give"}).description(Lang.COMMAND_GIVE_DESC)).permission(Perms.COMMAND_GIVE)).withArgument(ArgumentTypes.player((String)"player").required()).withArgument(CommandArguments.forCrate(plugin).required()).withArgument(ArgumentTypes.integerAbs((String)"amount").localized(Lang.COMMAND_ARGUMENT_NAME_AMOUNT).withSamples(context -> Lists.newList((Object[])new String[]{"1", "5", "10"}))).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentFeedback()).executes((context, arguments) -> BaseCommands.giveCrate(plugin, context, arguments)));
        root.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"open"}).description(Lang.COMMAND_OPEN_DESC)).permission(Perms.COMMAND_OPEN)).playerOnly()).withArgument(CommandArguments.forCrate(plugin).required()).executes((context, arguments) -> BaseCommands.openCrate(plugin, context, arguments)));
        root.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"openfor"}).description(Lang.COMMAND_OPEN_FOR_DESC)).permission(Perms.COMMAND_OPEN_FOR)).withArgument(ArgumentTypes.player((String)"player").required()).withArgument(CommandArguments.forCrate(plugin).required()).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.force()).executes((context, arguments) -> BaseCommands.openCrateFor(plugin, context, arguments)));
        root.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"preview"}).description(Lang.COMMAND_PREVIEW_DESC)).permission(Perms.COMMAND_PREVIEW)).withArgument(CommandArguments.forCrate(plugin).required()).withArgument(ArgumentTypes.playerName((String)"player").permission(Perms.COMMAND_PREVIEW_OTHERS)).executes((context, arguments) -> BaseCommands.previewCrate(plugin, context, arguments)));
        root.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"resetcooldown"}).description(Lang.COMMAND_RESET_COOLDOWN_DESC)).permission(Perms.COMMAND_RESETCOOLDOWN)).withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.forCrate(plugin).required()).executes((context, arguments) -> BaseCommands.resetCrateCooldown(plugin, context, arguments)));
    }

    @NotNull
    private static List<String> getCoords(@NotNull TabContext context, @NotNull Function<Location, Integer> function) {
        Player player = context.getPlayer();
        if (player == null) {
            return Collections.emptyList();
        }
        Location location = player.getLocation();
        return Lists.newList((Object[])new String[]{String.valueOf(function.apply(location))});
    }

    @NotNull
    private static DirectNodeBuilder buildKeyManage(@NotNull CratesPlugin plugin, @NotNull DirectNodeBuilder builder) {
        return builder.withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.forKey(plugin).required()).withArgument(ArgumentTypes.integerAbs((String)"amount").localized(Lang.COMMAND_ARGUMENT_NAME_AMOUNT).withSamples(context -> Lists.newList((Object[])new String[]{"1", "5", "10"}))).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentFeedback());
    }

    private static boolean dropCrate(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Crate crate = (Crate)((Object)arguments.getArgument("crate", Crate.class));
        double x = arguments.getDoubleArgument("x");
        double y = arguments.getDoubleArgument("y");
        double z = arguments.getDoubleArgument("z");
        World world = arguments.getWorldArgument("world");
        Location location = new Location(world, x, y, z);
        if (!plugin.getCrateManager().dropCrateItem(crate, location)) {
            return false;
        }
        Lang.COMMAND_DROP_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace(crate.replacePlaceholders()).replace(Placeholders.forLocation((Location)location)));
        return true;
    }

    private static boolean openEditor(@NotNull CratesPlugin plugin, @NotNull CommandContext context) {
        plugin.getEditorManager().openEditor(context.getPlayerOrThrow());
        return true;
    }

    private static boolean giveCrate(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = arguments.getPlayerArgument("player");
        Crate crate = (Crate)((Object)arguments.getArgument("crate", Crate.class));
        int amount = arguments.getIntArgument("amount", 1);
        plugin.getCrateManager().giveCrateItem(player, crate, amount);
        if (!arguments.hasFlag("s")) {
            Lang.COMMAND_GIVE_NOTIFY.getMessage().send((CommandSender)player, replacer -> replacer.replace("%amount%", (Object)amount).replace(crate.replacePlaceholders()));
        }
        if (!arguments.hasFlag("sf") && context.getSender() != player) {
            Lang.COMMAND_GIVE_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace(Placeholders.forPlayer((Player)player)).replace("%amount%", (Object)amount).replace(crate.replacePlaceholders()));
        }
        return true;
    }

    private static boolean openCrate(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Crate crate = (Crate)((Object)arguments.getArgument("crate", Crate.class));
        Player player = context.getPlayerOrThrow();
        plugin.getCrateManager().openCrate(player, new CrateSource(crate), new OpenSettings());
        return true;
    }

    private static boolean openCrateFor(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = arguments.getPlayerArgument("player");
        Crate crate = (Crate)((Object)arguments.getArgument("crate", Crate.class));
        if (!arguments.hasFlag("s")) {
            Lang.COMMAND_OPEN_FOR_NOTIFY.getMessage().send(context.getSender(), replacer -> replacer.replace(crate.replacePlaceholders()));
        }
        if (context.getSender() != player) {
            Lang.COMMAND_OPEN_FOR_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace(Placeholders.forPlayer((Player)player)).replace(crate.replacePlaceholders()));
        }
        boolean force = arguments.hasFlag("f");
        plugin.getCrateManager().openCrate(player, new CrateSource(crate), new OpenSettings().setForce(force));
        return true;
    }

    private static boolean previewCrate(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Crate crate = (Crate)((Object)arguments.getArgument("crate", Crate.class));
        Player player = plugin.getServer().getPlayer(arguments.getStringArgument("player", context.getSender().getName()));
        if (player == null) {
            context.errorBadPlayer();
            return false;
        }
        plugin.getCrateManager().previewCrate(player, new CrateSource(crate));
        if (context.getSender() != player) {
            Lang.COMMAND_PREVIEW_DONE_OTHERS.getMessage().send(context.getSender(), replacer -> replacer.replace(Placeholders.forPlayer((Player)player)).replace(crate.replacePlaceholders()));
        }
        return true;
    }

    private static boolean resetCrateCooldown(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            Crate crate = (Crate)((Object)((Object)arguments.getArgument("crate", Crate.class)));
            user.getCrateData(crate).setOpenCooldown(0L);
            plugin.getUserManager().save((AbstractUser)user);
            Lang.COMMAND_RESET_COOLDOWN_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace(crate.replacePlaceholders()));
        });
        return true;
    }

    private static boolean dropKey(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)((Object)arguments.getArgument("key", CrateKey.class));
        double x = arguments.getDoubleArgument("x");
        double y = arguments.getDoubleArgument("y");
        double z = arguments.getDoubleArgument("z");
        World world = arguments.getWorldArgument("world");
        Location location = new Location(world, x, y, z);
        if (!plugin.getKeyManager().dropKeyItem(key, location)) {
            return false;
        }
        Lang.COMMAND_DROP_KEY_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace(key.replacePlaceholders()).replace(Placeholders.forLocation((Location)location)));
        return true;
    }

    private static boolean giveKeyAll(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)((Object)arguments.getArgument("key", CrateKey.class));
        int amount = arguments.getIntArgument("amount", 1);
        if (amount == 0) {
            return false;
        }
        boolean silent = arguments.hasFlag("s");
        Players.getOnline().forEach(player -> {
            if (!player.hasPermission((Permission)Perms.INCLUDE_KEY_GIVEALL)) {
                return;
            }
            plugin.getKeyManager().giveKey((Player)player, key, amount);
            if (!silent) {
                Lang.COMMAND_KEY_GIVE_NOTIFY.getMessage().send((CommandSender)player, replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
        });
        if (!arguments.hasFlag("sf")) {
            Lang.COMMAND_KEY_GIVE_ALL_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
        }
        return true;
    }

    private static boolean inspectKeys(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        plugin.getUserManager().manageUser(arguments.getStringArgument("player", context.getSender().getName()), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            Lang.COMMAND_KEY_INSPECT_LIST.getMessage().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%entry%", list -> plugin.getKeyManager().getKeys().forEach(key -> {
                if (!key.isVirtual()) {
                    return;
                }
                list.add((String)key.replacePlaceholders().apply(Lang.COMMAND_KEY_INSPECT_ENTRY.getString().replace("%amount%", NumberUtil.format((double)user.countKeys(key.getId())))));
            })));
        });
        return true;
    }

    private static boolean giveKey(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)((Object)arguments.getArgument("key", CrateKey.class));
        int amount = arguments.getIntArgument("amount", 1);
        if (amount <= 0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            plugin.getKeyManager().giveKey((CrateUser)((Object)user), key, amount);
            plugin.getUserManager().save((AbstractUser)user);
            Player target = user.getPlayer();
            if (target != null && !arguments.hasFlag("s")) {
                Lang.COMMAND_KEY_GIVE_NOTIFY.getMessage().send((CommandSender)target, replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
            if (!arguments.hasFlag("sf")) {
                Lang.COMMAND_KEY_GIVE_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
        });
        return true;
    }

    private static boolean setKey(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)((Object)arguments.getArgument("key", CrateKey.class));
        int amount = arguments.getIntArgument("amount", 1);
        if (amount <= 0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            plugin.getKeyManager().setKey((CrateUser)((Object)user), key, amount);
            plugin.getUserManager().save((AbstractUser)user);
            Player target = user.getPlayer();
            if (target != null && !arguments.hasFlag("s")) {
                Lang.COMMAND_KEY_SET_NOTIFY.getMessage().send((CommandSender)target, replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
            if (!arguments.hasFlag("sf")) {
                Lang.COMMAND_KEY_SET_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
        });
        return true;
    }

    private static boolean takeKey(@NotNull CratesPlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        CrateKey key = (CrateKey)((Object)arguments.getArgument("key", CrateKey.class));
        int amount = arguments.getIntArgument("amount", 1);
        if (amount <= 0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            plugin.getKeyManager().takeKey((CrateUser)((Object)user), key, amount);
            plugin.getUserManager().save((AbstractUser)user);
            Player target = user.getPlayer();
            if (target != null && !arguments.hasFlag("s")) {
                Lang.COMMAND_KEY_TAKE_NOTIFY.getMessage().send((CommandSender)target, replacer -> replacer.replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
            if (!arguments.hasFlag("sf")) {
                Lang.COMMAND_KEY_TAKE_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)amount).replace(key.replacePlaceholders()));
            }
        });
        return true;
    }
}

