/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening.inventory.spinner.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.Rarity;
import su.nightexpress.excellentcrates.opening.inventory.InventoryOpening;
import su.nightexpress.excellentcrates.opening.inventory.spinner.AbstractSpinner;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinMode;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerData;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.random.Rnd;

public class RewardSpinner
extends AbstractSpinner {
    private final Set<Rarity> rarities;
    private final List<Reward> rewards;
    private int rewardIndex;

    public RewardSpinner(@NotNull SpinnerData data, @NotNull InventoryOpening opening, @NotNull Set<Rarity> rarities) {
        super(data, opening);
        this.rarities = rarities;
        this.rewards = new ArrayList<Reward>();
        this.rewardIndex = 0;
        this.prepareRewards();
    }

    private boolean isWinSlot(int slot) {
        return Lists.contains((int[])this.winSlots, (int)slot);
    }

    private void prepareRewards() {
        for (int winSlot : this.winSlots) {
            if (!Lists.contains((int[])this.slots, (int)winSlot)) continue;
            this.rewards.add(this.rollReward());
        }
    }

    @Nullable
    private Reward rollReward() {
        Crate crate = this.opening.getCrate();
        Player player = this.opening.getPlayer();
        if (((Boolean)Config.OPENINGS_GUI_SIMULATE_REAL_CHANCES.get()).booleanValue()) {
            HashMap rarityMap = new HashMap();
            this.rarities.forEach(rarity -> {
                if (crate.hasRewards(player, (Rarity)rarity)) {
                    rarityMap.put(rarity, rarity.getWeight());
                }
            });
            if (rarityMap.isEmpty()) {
                return null;
            }
            Rarity rarity2 = (Rarity)Rnd.getByWeight(rarityMap);
            return crate.rollReward(this.opening.getPlayer(), rarity2);
        }
        List<Reward> rewards = crate.getRewards(player);
        rewards.removeIf(reward -> !this.rarities.contains(reward.getRarity()));
        return rewards.isEmpty() ? null : (Reward)Rnd.get(rewards);
    }

    @Override
    @NotNull
    public ItemStack createItem(int slot) {
        Reward reward;
        Reward reward2 = reward = this.shouldUsePredictedReward(slot) ? this.rewards.get(this.rewardIndex++) : this.rollReward();
        if (reward == null) {
            return new ItemStack(Material.AIR);
        }
        return reward.getPreviewItem();
    }

    private boolean shouldUsePredictedReward(int slot) {
        if (this.rewardIndex >= this.rewards.size()) {
            return false;
        }
        int spinsLeft = Math.toIntExact((long)this.requiredSpins - this.spinCount);
        SpinMode mode = this.data.getMode();
        if (mode == SpinMode.SYNCRHONIZED) {
            return spinsLeft == 1;
        }
        if (mode == SpinMode.RANDOM || mode == SpinMode.INDEPENDENT) {
            return spinsLeft == 1 && this.isWinSlot(slot);
        }
        if (mode == SpinMode.SEQUENTAL) {
            for (int winSlot : this.winSlots) {
                int index = Lists.indexOf((int[])this.slots, (int)winSlot) + 1;
                if (index <= 0 || spinsLeft != index) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void spinRandom() {
        this.spinIndependent();
    }

    @Override
    protected void onStop() {
        Player player = this.opening.getPlayer();
        this.rewards.forEach(reward -> reward.give(player));
    }
}

