/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.key;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.config.Keys;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.item.ItemTypes;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.key.KeyListener;
import su.nightexpress.excellentcrates.user.CrateUser;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.excellentcrates.util.inspect.Inspectors;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.StringUtil;

public class KeyManager
extends AbstractManager<CratesPlugin> {
    private final Map<String, CrateKey> keyByIdMap = new HashMap<String, CrateKey>();

    public KeyManager(@NotNull CratesPlugin plugin) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.loadKeys();
        ((CratesPlugin)this.plugin).runTask(task -> this.runInspections());
        this.addListener((SimpeListener)new KeyListener((CratesPlugin)this.plugin, this));
    }

    protected void onShutdown() {
        this.keyByIdMap.clear();
    }

    private void loadKeys() {
        for (File file : FileUtil.getFiles((String)(String.valueOf(((CratesPlugin)this.plugin).getDataFolder()) + "/keys/"), (boolean)true)) {
            this.loadKey(new CrateKey((CratesPlugin)this.plugin, file));
        }
        ((CratesPlugin)this.plugin).info("Loaded " + this.keyByIdMap.size() + " crate keys.");
    }

    private void loadKey(@NotNull CrateKey crateKey) {
        if (crateKey.load()) {
            this.keyByIdMap.put(crateKey.getId(), crateKey);
        } else {
            ((CratesPlugin)this.plugin).error("Key not loaded: '" + crateKey.getFile().getName() + "'.");
        }
    }

    private void runInspections() {
        this.getKeys().forEach(key -> Inspectors.KEY.printConsole((CratesPlugin)this.plugin, (CrateKey)((Object)key), "Problems in key config (" + key.getFile().getPath() + "):"));
    }

    public boolean create(@NotNull String id) {
        if (this.getKeyById(id = CrateUtils.createID(id)) != null) {
            return false;
        }
        File file = new File(String.valueOf(((CratesPlugin)this.plugin).getDataFolder()) + "/keys/", id + ".yml");
        FileUtil.create((File)file);
        CrateKey key = new CrateKey((CratesPlugin)this.plugin, file);
        key.setName(StringUtil.capitalizeFully((String)id) + " Key");
        key.setVirtual(false);
        ItemStack item = new ItemStack(Material.TRIPWIRE_HOOK);
        ItemUtil.editMeta((ItemStack)item, meta -> meta.setDisplayName(key.getName()));
        key.setProvider(ItemTypes.vanilla(item));
        key.save();
        this.loadKey(key);
        return true;
    }

    public boolean delete(@NotNull CrateKey key) {
        if (key.getFile().delete()) {
            this.keyByIdMap.remove(key.getId());
            return true;
        }
        return false;
    }

    public boolean dropKeyItem(@NotNull CrateKey key, @NotNull Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        world.dropItemNaturally(location, key.getItem());
        return true;
    }

    @NotNull
    public Map<String, CrateKey> getKeyByIdMap() {
        return this.keyByIdMap;
    }

    @NotNull
    public Set<CrateKey> getKeys() {
        return new HashSet<CrateKey>(this.keyByIdMap.values());
    }

    @NotNull
    public List<String> getKeyIds() {
        return new ArrayList<String>(this.keyByIdMap.keySet());
    }

    @Nullable
    public CrateKey getKeyById(@NotNull String id) {
        return this.keyByIdMap.get(id.toLowerCase());
    }

    @Nullable
    public CrateKey getKeyByItem(@NotNull ItemStack item) {
        String id = PDCUtil.getString((ItemStack)item, (NamespacedKey)Keys.keyId).orElse(null);
        return id == null ? null : this.getKeyById(id);
    }

    @NotNull
    public Set<CrateKey> getKeys(@NotNull Player player, @NotNull Crate crate) {
        return crate.getRequiredKeys().stream().filter(key -> this.hasKey(player, (CrateKey)((Object)key))).collect(Collectors.toSet());
    }

    @Nullable
    public ItemStack getFirstKeyStack(@NotNull Player player, @NotNull CrateKey key) {
        Predicate<ItemStack> predicate = this.getItemStackPredicate(key);
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType().isAir() || !predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Nullable
    public CrateKey getOpenKey(@NotNull Player player, @NotNull Crate crate) {
        PlayerInventory inventory = player.getInventory();
        ArrayList<ItemStack> content = new ArrayList<ItemStack>();
        if (!crate.isAllVirtualKeys()) {
            content.add(inventory.getItemInMainHand());
            content.add(inventory.getItemInOffHand());
            if (!((Boolean)Config.CRATE_HOLD_KEY_TO_OPEN.get()).booleanValue()) {
                content.addAll(Arrays.asList(inventory.getContents()));
            }
        }
        for (ItemStack itemStack : content) {
            CrateKey key = itemStack == null ? null : this.getKeyByItem(itemStack);
            if (key == null || !crate.isGoodKey(key)) continue;
            return key;
        }
        CrateUser user = (CrateUser)((CratesPlugin)this.plugin).getUserManager().getOrFetch(player);
        for (CrateKey key : crate.getRequiredKeys()) {
            if (!key.isVirtual() || !user.hasKeys(key)) continue;
            return key;
        }
        return null;
    }

    public boolean isKey(@NotNull ItemStack item) {
        return this.getKeyByItem(item) != null;
    }

    public boolean isKey(@NotNull ItemStack item, @NotNull CrateKey key) {
        return this.getItemStackPredicate(key).test(item);
    }

    public boolean isKey(@NotNull ItemStack item, @NotNull Crate crate) {
        CrateKey key = this.getKeyByItem(item);
        return key != null && crate.isGoodKey(key);
    }

    public int getKeysAmount(@NotNull Player player, @NotNull Crate crate) {
        return crate.getRequiredKeys().stream().mapToInt(key -> this.getKeysAmount(player, (CrateKey)((Object)key))).sum();
    }

    public int getKeysAmount(@NotNull Player player, @NotNull CrateKey key) {
        if (key.isVirtual()) {
            CrateUser user = (CrateUser)((CratesPlugin)this.plugin).getUserManager().getOrFetch(player);
            return user.countKeys(key);
        }
        return Players.countItem((Player)player, this.getItemStackPredicate(key));
    }

    public boolean hasKey(@NotNull Player player, @NotNull Crate crate) {
        return crate.getRequiredKeys().stream().anyMatch(key -> this.hasKey(player, (CrateKey)((Object)key)));
    }

    public boolean hasKey(@NotNull Player player, @NotNull CrateKey key) {
        if (key.isVirtual()) {
            return this.getKeysAmount(player, key) > 0;
        }
        return this.getFirstKeyStack(player, key) != null;
    }

    public void giveKeysOnHold(@NotNull Player player) {
        CrateUser user = (CrateUser)((CratesPlugin)this.plugin).getUserManager().getOrFetch(player);
        user.getKeysOnHold().forEach((keyId, amount) -> {
            CrateKey crateKey = this.getKeyById((String)keyId);
            if (crateKey == null) {
                return;
            }
            this.giveKey(player, crateKey, (int)amount);
        });
        user.cleanKeysOnHold();
        ((CratesPlugin)this.plugin).getUserManager().save(user);
    }

    public void setKey(@NotNull CrateUser user, @NotNull CrateKey key, int amount) {
        Player player = user.getPlayer();
        if (player != null) {
            this.setKey(player, key, amount);
            return;
        }
        if (key.isVirtual()) {
            user.setKeys(key.getId(), amount);
        }
    }

    public void setKey(@NotNull Player player, @NotNull CrateKey key, int amount) {
        if (key.isVirtual()) {
            CrateUser user = (CrateUser)((CratesPlugin)this.plugin).getUserManager().getOrFetch(player);
            user.setKeys(key.getId(), amount);
            ((CratesPlugin)this.plugin).getUserManager().save(user);
        } else {
            ItemStack keyItem = key.getItem();
            int has = Players.countItem((Player)player, (ItemStack)keyItem);
            if (has > amount) {
                Players.takeItem((Player)player, (ItemStack)keyItem, (int)(has - amount));
            } else if (has < amount) {
                Players.addItem((Player)player, (ItemStack)keyItem, (int)(amount - has));
            }
        }
    }

    public void giveKey(@NotNull CrateUser user, @NotNull CrateKey key, int amount) {
        Player player = user.getPlayer();
        if (player != null) {
            this.giveKey(player, key, amount);
            return;
        }
        if (key.isVirtual()) {
            user.addKeys(key.getId(), amount);
        } else {
            user.addKeysOnHold(key.getId(), amount);
        }
    }

    public void giveKey(@NotNull Player player, @NotNull CrateKey key, int amount) {
        if (key.isVirtual()) {
            CrateUser user = (CrateUser)((CratesPlugin)this.plugin).getUserManager().getOrFetch(player);
            user.addKeys(key.getId(), amount);
            ((CratesPlugin)this.plugin).getUserManager().save(user);
        } else {
            ItemStack keyItem = key.getItem();
            keyItem.setAmount(amount < 0 ? Math.abs(amount) : amount);
            Players.addItem((Player)player, (ItemStack[])new ItemStack[]{keyItem});
        }
    }

    @Nullable
    public CrateKey takeKey(@NotNull Player player, @NotNull Crate crate) {
        CrateKey key = this.getKeys(player, crate).stream().findFirst().orElse(null);
        if (key == null) {
            return null;
        }
        this.takeKey(player, key, 1);
        return key;
    }

    public void takeKey(@NotNull CrateUser user, @NotNull CrateKey key, int amount) {
        Player player = user.getPlayer();
        if (player != null) {
            this.takeKey(player, key, amount);
            return;
        }
        if (key.isVirtual()) {
            user.takeKeys(key.getId(), amount);
        }
    }

    public void takeKey(@NotNull Player player, @NotNull CrateKey key, int amount) {
        if (key.isVirtual()) {
            CrateUser user = (CrateUser)((CratesPlugin)this.plugin).getUserManager().getOrFetch(player);
            user.takeKeys(key.getId(), amount);
            ((CratesPlugin)this.plugin).getUserManager().save(user);
        } else {
            Predicate<ItemStack> predicate = this.getItemStackPredicate(key);
            int has = Players.countItem((Player)player, predicate);
            if (has < amount) {
                amount = has;
            }
            Players.takeItem((Player)player, predicate, (int)amount);
        }
    }

    @NotNull
    private Predicate<ItemStack> getItemStackPredicate(@NotNull CrateKey key) {
        return stack -> this.getKeyByItem((ItemStack)stack) == key;
    }
}

