/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.item.provider;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.api.item.ItemProvider;
import su.nightexpress.excellentcrates.api.item.ItemType;
import su.nightexpress.excellentcrates.config.Keys;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public abstract class AbstractItemProvider
implements ItemProvider {
    private final ItemType type;

    public AbstractItemProvider(@NotNull ItemType type) {
        this.type = type;
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        if (this.isDummy()) {
            return;
        }
        config.set(path + ".Type", (Object)this.type.name());
        this.writeAdditional(config, path);
    }

    protected abstract void writeAdditional(@NotNull FileConfig var1, @NotNull String var2);

    @NotNull
    protected ItemStack getDummyItem() {
        ItemStack itemStack = NightItem.fromType((Material)Material.BARRIER).localized(Lang.OTHER_BROKEN_ITEM).getItemStack();
        PDCUtil.set((ItemStack)itemStack, (NamespacedKey)Keys.dummyItem, (boolean)true);
        return itemStack;
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public boolean canProduceItem() {
        return !this.isDummy() && this.isValid();
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        ItemStack itemStack = this.createItemStack();
        if (itemStack == null || itemStack.getType().isAir()) {
            return this.getDummyItem();
        }
        return itemStack;
    }

    @Override
    @NotNull
    public ItemType getType() {
        return this.type;
    }
}

