/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.key;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.item.ItemProvider;
import su.nightexpress.excellentcrates.config.EditorLang;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.item.ItemTypes;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.language.entry.LangString;
import su.nightexpress.nightcore.ui.UIUtils;
import su.nightexpress.nightcore.ui.dialog.Dialog;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.click.ClickResult;
import su.nightexpress.nightcore.ui.menu.confirmation.Confirmation;
import su.nightexpress.nightcore.ui.menu.item.ItemOptions;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class KeyOptionsMenu
extends LinkedMenu<CratesPlugin, CrateKey> {
    private static final String SKULL_STACK = "e2e7ac70bf77ba3dd33f4cb78d88ac149ac6036cef2eac8e7a6fd3676fbaf1aa";

    public KeyOptionsMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_KEY_LIST.getString());
        this.addItem(MenuItem.buildReturn((Menu)this, (int)40, (viewer, event) -> this.runNextTick(() -> plugin.getEditorManager().openKeyList(viewer.getPlayer()))));
        this.addItem(ItemUtil.getCustomHead((String)"94f90c7bd60bfd0dfc31808d0484d8c2db9959f68df91fbf29423a3da62429a6"), EditorLang.KEY_EDIT_DELETE, 8, (viewer, event, key) -> {
            Player player = viewer.getPlayer();
            UIUtils.openConfirmation((Player)player, (Confirmation)Confirmation.builder().onAccept((viewer1, event1) -> {
                plugin.getKeyManager().delete((CrateKey)((Object)key));
                plugin.runTask(task -> plugin.getEditorManager().openKeyList(player));
            }).onReturn((viewer1, event1) -> plugin.runTask(task -> plugin.getEditorManager().openKeyOptions(player, (CrateKey)((Object)key)))).build());
        });
        this.addItem(Material.NAME_TAG, EditorLang.KEY_EDIT_NAME, 19, (viewer, event, key) -> this.handleInput(Dialog.builder((MenuViewer)viewer, (LangString)Lang.EDITOR_ENTER_DISPLAY_NAME, input -> {
            key.setName(input.getText());
            key.save();
            return true;
        })));
        this.addItem(Material.TRIPWIRE_HOOK, EditorLang.KEY_EDIT_ITEM, 21, (viewer, event, key) -> {
            ItemStack cursor = event.getCursor();
            if (cursor == null || cursor.getType().isAir()) {
                if (event.isLeftClick()) {
                    Players.addItem((Player)viewer.getPlayer(), (ItemStack[])new ItemStack[]{key.getItem()});
                } else if (event.isRightClick()) {
                    Players.addItem((Player)viewer.getPlayer(), (ItemStack[])new ItemStack[]{key.getRawItem()});
                }
                return;
            }
            event.getView().setCursor(null);
            ItemStack clean = CrateUtils.removeCrateTags(new ItemStack(cursor));
            if (!ItemTypes.isCustom(clean)) {
                key.setProvider(ItemTypes.vanilla(clean));
                key.setName(ItemUtil.getNameSerialized((ItemStack)clean));
                this.saveAndFlush(viewer);
            } else {
                this.runNextTick(() -> plugin.getEditorManager().openItemTypeMenu(viewer.getPlayer(), clean, provider -> {
                    key.setProvider((ItemProvider)provider);
                    key.setName(ItemUtil.getNameSerialized((ItemStack)clean));
                    key.save();
                    this.runNextTick(() -> this.open(viewer.getPlayer(), key));
                }));
            }
            event.getView().setCursor(null);
        }, ItemOptions.builder().setVisibilityPolicy(viewer -> !((CrateKey)((Object)((Object)this.getLink((MenuViewer)viewer)))).isVirtual()).build());
        this.addItem(NightItem.asCustomHead((String)SKULL_STACK), Lang.EDITOR_BUTTON_KEY_ITEM_STACKABLE, 23, (viewer, event, key) -> {
            key.setItemStackable(!key.isItemStackable());
            this.saveAndFlush(viewer);
        }, ItemOptions.builder().setVisibilityPolicy(viewer -> !((CrateKey)((Object)((Object)this.getLink((MenuViewer)viewer)))).isVirtual()).build());
        this.addItem(Material.ENDER_PEARL, EditorLang.KEY_EDIT_VIRTUAL, 25, (viewer, event, key) -> {
            key.setVirtual(!key.isVirtual());
            this.saveAndFlush(viewer);
        });
    }

    private void saveAndFlush(@NotNull MenuViewer viewer) {
        ((CrateKey)((Object)this.getLink(viewer))).save();
        this.runNextTick(() -> this.flush(viewer));
    }

    protected void onItemPrepare(@NotNull MenuViewer viewer, @NotNull MenuItem menuItem, @NotNull NightItem item) {
        super.onItemPrepare(viewer, menuItem, item);
        item.replacement(replacer -> replacer.replace(((CrateKey)((Object)((Object)this.getLink(viewer)))).replacePlaceholders()));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onClick(@NotNull MenuViewer viewer, @NotNull ClickResult result, @NotNull InventoryClickEvent event) {
        super.onClick(viewer, result, event);
        if (result.isInventory()) {
            event.setCancelled(false);
        }
    }
}

