/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.generic;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.item.ItemProvider;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.item.ItemTypes;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.item.ItemHandler;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class ItemTypeMenu
extends LinkedMenu<CratesPlugin, Data> {
    public static final int ITEM_SLOT = 13;

    public ItemTypeMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X3, Lang.EDITOR_TITLE_ITEM_TYPE.getString());
        this.addItem(NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).toMenuItem().setPriority(-1).setSlots(IntStream.range(0, 27).toArray()));
        this.addItem(NightItem.asCustomHead((String)"a71402201d4d8f4613df7ca4c691625f1dc5ff429a90cf1f51668d80619758a3").localized(Lang.EDITOR_BUTTON_ITEM_TYPE_BY_NBT).toMenuItem().setHandler(ItemHandler.forClick((viewer, event) -> this.select(viewer, ItemTypes::vanilla))).setSlots(new int[]{10}));
        this.addItem(NightItem.asCustomHead((String)"543f5ed19f634370dd9c5b9e8772c06f9917a3cf1c69b4433a5243b058d2d44c").localized(Lang.EDITOR_BUTTON_ITEM_TYPE_BY_ID).toMenuItem().setHandler(ItemHandler.forClick((viewer, event) -> this.select(viewer, ItemTypes::fromItem))).setSlots(new int[]{16}));
    }

    public void open(@NotNull Player player, @NotNull ItemStack itemStack, @NotNull Consumer<ItemProvider> result) {
        this.open(player, new Data(result, itemStack));
    }

    private void select(@NotNull MenuViewer viewer, @NotNull Function<ItemStack, ItemProvider> function) {
        Inventory inventory = viewer.getInventory();
        if (inventory == null) {
            return;
        }
        Player player = viewer.getPlayer();
        Data data = (Data)this.getLink(player);
        ItemStack itemStack = data.itemStack;
        ItemProvider provider = function.apply(itemStack);
        data.result.accept(provider);
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
        ItemStack itemStack = ((Data)this.getLink((MenuViewer)viewer)).itemStack;
        inventory.setItem(13, itemStack);
    }

    public record Data(@NotNull Consumer<ItemProvider> result, @NotNull ItemStack itemStack) {
    }
}

