/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.reward;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.api.crate.RewardType;
import su.nightexpress.excellentcrates.api.item.ItemProvider;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.Rarity;
import su.nightexpress.excellentcrates.crate.limit.LimitValues;
import su.nightexpress.excellentcrates.crate.reward.impl.CommandReward;
import su.nightexpress.excellentcrates.crate.reward.impl.ItemReward;
import su.nightexpress.excellentcrates.item.ItemTypes;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Lists;

public class RewardFactory {
    @NotNull
    public static Reward read(@NotNull CratesPlugin plugin, @NotNull Crate crate, @NotNull String id, @NotNull FileConfig config, @NotNull String path) {
        if (config.contains(path + ".Preview")) {
            ItemStack previewItem = config.getItemEncoded(path + ".Preview");
            if (previewItem == null) {
                previewItem = new ItemStack(Material.BARRIER);
            }
            ItemProvider provider = ItemTypes.vanilla(previewItem);
            config.set(path + ".PreviewData", (Object)provider);
            config.remove(path + ".Preview");
        }
        if (config.contains(path + ".Win_Limits")) {
            int winLimitAmount = config.getInt(path + ".Win_Limits.Amount", -1);
            long winLimitCooldown = config.getLong(path + ".Win_Limits.Cooldown", 0L);
            LimitValues winLimit = new LimitValues(winLimitAmount > 0, winLimitAmount, winLimitCooldown, 1);
            winLimit.write(config, path + ".Win_Limit.Player");
            config.remove(path + ".Win_Limits");
        }
        if (!config.contains(path + ".Type")) {
            if (!config.getStringList(path + ".Commands").isEmpty()) {
                config.set(path + ".Type", (Object)RewardType.COMMAND.name());
                config.remove(path + ".Items");
            } else {
                config.set(path + ".Type", (Object)RewardType.ITEM.name());
                config.remove(path + ".Commands");
            }
        }
        String rarityId = String.valueOf(config.getString(path + ".Rarity"));
        Rarity rarity = plugin.getCrateManager().getRarity(rarityId);
        if (rarity == null) {
            plugin.error("Invalid rarity '" + rarityId + "', fallback to default rarity. Caused by '" + config.getFile().getName() + "' -> '" + path + "'.");
            rarity = plugin.getCrateManager().getMostCommonRarity();
        }
        RewardType type = (RewardType)config.getEnum(path + ".Type", RewardType.class, (Enum)RewardType.ITEM);
        Reward reward = RewardFactory.create(plugin, crate, id, rarity, type);
        reward.load(config, path);
        return reward;
    }

    @NotNull
    public static Reward wizardCreation(@NotNull CratesPlugin plugin, @NotNull Crate crate, @NotNull ItemStack source, @NotNull RewardType type, @NotNull ItemProvider provider) {
        Rarity rarity = plugin.getCrateManager().getMostCommonRarity();
        String id = CrateUtils.generateRewardID(crate, provider);
        Reward reward = RewardFactory.create(plugin, crate, id, rarity, type);
        if (reward instanceof ItemReward) {
            ItemReward itemReward = (ItemReward)reward;
            itemReward.setItems(Lists.newList((Object[])new ItemProvider[]{provider}));
        } else if (reward instanceof CommandReward) {
            CommandReward commandReward = (CommandReward)reward;
            commandReward.setPreview(provider);
            commandReward.setName(ItemUtil.getNameSerialized((ItemStack)source));
            commandReward.setDescription(ItemUtil.getLoreSerialized((ItemStack)source));
        }
        return reward;
    }

    @NotNull
    public static Reward create(@NotNull CratesPlugin plugin, @NotNull Crate crate, @NotNull String id, @NotNull Rarity rarity, @NotNull RewardType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case RewardType.ITEM -> new ItemReward(plugin, crate, id, rarity);
            case RewardType.COMMAND -> new CommandReward(plugin, crate, id, rarity);
        };
    }
}

