/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.crate.impl.Milestone;
import su.nightexpress.excellentcrates.user.CrateUser;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.tag.Tags;

public class MilestonesMenu
extends LinkedMenu<CratesPlugin, CrateSource>
implements Filled<Milestone>,
ConfigBased {
    private static final String PLACEHOLDER_OPENINGS_LEFT = "%openings_left%";
    private String mileCompName;
    private List<String> mileCompLore;
    private String mileIncName;
    private List<String> mileIncLore;
    private int[] mileSlots;
    private NightItem mileCompItem;
    private NightItem mileIncItem;
    private boolean pointerEnabled;
    private int pointerPerMile;
    private int[] pointerSlots;
    private NightItem pointerComp;
    private NightItem pointerInc;

    public MilestonesMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X3, Tags.BLACK.wrap("Crate Milestones"));
        this.load(FileConfig.loadOrExtract((NightCorePlugin)plugin, (String)"milestones.yml"));
    }

    @NotNull
    protected String getTitle(@NotNull MenuViewer viewer) {
        CrateSource source = (CrateSource)this.getLink(viewer.getPlayer());
        return (String)source.getCrate().replacePlaceholders().apply(this.title);
    }

    @NotNull
    public MenuFiller<Milestone> createFiller(@NotNull MenuViewer viewer) {
        MenuFiller.Builder autoFill = MenuFiller.builder((Filled)this);
        CrateSource source = (CrateSource)this.getLink(viewer.getPlayer());
        Player player = viewer.getPlayer();
        AtomicInteger counter = new AtomicInteger();
        Crate crate = source.getCrate();
        CrateUser user = (CrateUser)((CratesPlugin)this.plugin).getUserManager().getOrFetch(player);
        autoFill.setSlots(this.mileSlots);
        autoFill.setItems(crate.getMilestones().stream().sorted(Comparator.comparing(Milestone::getOpenings)).toList());
        autoFill.setItemCreator(milestone -> {
            ArrayList<String> lore;
            String name;
            Reward reward = milestone.getReward();
            if (reward == null) {
                return new NightItem(Material.AIR);
            }
            int openings = user.getCrateData(crate).getMilestone();
            boolean isCompleted = openings >= milestone.getOpenings();
            NightItem item = NightItem.fromItemStack((ItemStack)reward.getPreviewItem());
            if (this.pointerEnabled) {
                NightItem pointerItem = (isCompleted ? this.pointerComp : this.pointerInc).copy();
                int[] pointerSlots = new int[this.pointerPerMile];
                int start = this.pointerPerMile * counter.getAndIncrement();
                System.arraycopy(this.pointerSlots, start, pointerSlots, 0, this.pointerPerMile);
                MenuItem menuItem = MenuItem.builder((NightItem)pointerItem).setSlots(pointerSlots).setPriority(100).build();
                this.addItem(viewer, menuItem);
            }
            if (isCompleted) {
                name = this.mileCompName;
                lore = new ArrayList<String>(this.mileCompLore);
                if (this.mileCompItem != null) {
                    item = this.mileCompItem;
                }
            } else {
                name = this.mileIncName;
                lore = new ArrayList<String>(this.mileIncLore);
                if (this.mileIncItem != null) {
                    item = this.mileIncItem;
                }
            }
            return item.copy().setDisplayName(name).setLore(lore).hideAllComponents().replacement(replacer -> replacer.replace(crate.replacePlaceholders()).replace(reward.replacePlaceholders()).replace(milestone.replacePlaceholders()).replace(PLACEHOLDER_OPENINGS_LEFT, (Object)NumberUtil.format((double)(milestone.getOpenings() - openings))));
        });
        return autoFill.build();
    }

    public void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        this.mileCompName = (String)ConfigValue.create((String)"Milestones.Completed.Name", (String)(Tags.LIGHT_GREEN.wrap(Tags.BOLD.wrap("%milestone_openings% Openings")) + " " + Tags.GRAY.wrap("(" + Tags.WHITE.wrap("Completed") + ")")), (String[])new String[0]).read(config);
        this.mileCompLore = (List)ConfigValue.create((String)"Milestones.Completed.Lore", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GREEN.wrap(Tags.BOLD.wrap("Info:")), Tags.LIGHT_GREEN.wrap("\u25aa " + Tags.LIGHT_GRAY.wrap("Reward: ") + "%reward_name%"), "", Tags.LIGHT_GREEN.wrap("\u2714") + " " + Tags.LIGHT_GRAY.wrap("You have completed this milestone.")}), (String[])new String[0]).read(config);
        this.mileIncName = (String)ConfigValue.create((String)"Milestones.Incompleted.Name", (String)(Tags.LIGHT_YELLOW.wrap(Tags.BOLD.wrap("%milestone_openings% Openings")) + " " + Tags.GRAY.wrap("(" + Tags.WHITE.wrap("Incompleted") + ")")), (String[])new String[0]).read(config);
        this.mileIncLore = (List)ConfigValue.create((String)"Milestones.Incompleted.Lore", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.wrap(Tags.BOLD.wrap("Info:")), Tags.LIGHT_YELLOW.wrap("\u25aa " + Tags.LIGHT_GRAY.wrap("Openings Left: ") + PLACEHOLDER_OPENINGS_LEFT), Tags.LIGHT_YELLOW.wrap("\u25aa " + Tags.LIGHT_GRAY.wrap("Reward: ") + "%reward_name%"), "", Tags.LIGHT_RED.wrap("\u2718") + " " + Tags.LIGHT_GRAY.wrap("You haven''t completed this milestone yet.")}), (String[])new String[0]).read(config);
        this.mileSlots = (int[])ConfigValue.create((String)"Milestones.Slots", (int[])new int[]{10, 12, 14, 16}, (String[])new String[0]).read(config);
        if (((Boolean)ConfigValue.create((String)"Milestones.Completed.Custom_Item.Enabled", (boolean)true, (String[])new String[0]).read(config)).booleanValue()) {
            this.mileCompItem = (NightItem)ConfigValue.create((String)"Milestones.Completed.Custom_Item.Value", (NightItem)NightItem.asCustomHead((String)"a79a5c95ee17abfef45c8dc224189964944d560f19a44f19f8a46aef3fee4756"), (String[])new String[0]).read(config);
        }
        if (((Boolean)ConfigValue.create((String)"Milestones.Incompleted.Custom_Item.Enabled", (boolean)false, (String[])new String[0]).read(config)).booleanValue()) {
            this.mileIncItem = (NightItem)ConfigValue.create((String)"Milestones.Incompleted.Custom_Item.Value", (NightItem)NightItem.asCustomHead((String)"27548362a24c0fa8453e4d93e68c5969ddbde57bf6666c0319c1ed1e84d89065"), (String[])new String[0]).read(config);
        }
        this.pointerEnabled = (Boolean)ConfigValue.create((String)"Milestones.Pointer.Enabled", (boolean)true, (String[])new String[0]).read(config);
        this.pointerPerMile = (Integer)ConfigValue.create((String)"Milestones.Pointer.Per_Milestone", (int)2, (String[])new String[0]).read(config);
        this.pointerSlots = (int[])ConfigValue.create((String)"Milestones.Pointer.Slots", (int[])new int[]{1, 19, 3, 21, 5, 23, 7, 25}, (String[])new String[0]).read(config);
        this.pointerComp = (NightItem)ConfigValue.create((String)"Milestones.Pointer.Completed", (NightItem)new NightItem(Material.LIME_STAINED_GLASS_PANE), (String[])new String[0]).read(config);
        this.pointerInc = (NightItem)ConfigValue.create((String)"Milestones.Pointer.Incompleted", (NightItem)new NightItem(Material.WHITE_STAINED_GLASS_PANE), (String[])new String[0]).read(config);
        loader.addDefaultItem(MenuItem.buildReturn((Menu)this, (int)22, (viewer, event) -> {
            CrateSource source = (CrateSource)this.getLink(viewer.getPlayer());
            this.runNextTick(() -> ((CratesPlugin)this.plugin).getCrateManager().previewCrate(viewer.getPlayer(), source));
        }).setPriority(100));
        loader.addDefaultItem(MenuItem.buildNextPage((Menu)this, (int)17).setPriority(100));
        loader.addDefaultItem(MenuItem.buildPreviousPage((Menu)this, (int)9).setPriority(100));
        loader.addDefaultItem(NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).toMenuItem().setSlots(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 18, 19, 20, 21, 22, 23, 24, 25, 26}));
        loader.addDefaultItem(NightItem.fromType((Material)Material.GRAY_STAINED_GLASS_PANE).toMenuItem().setSlots(new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17}));
    }
}

