/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.impl;

import java.util.Collection;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.Placeholders;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.text.NightMessage;

public class Rarity {
    private final CratesPlugin plugin;
    private final String id;
    private String name;
    private double weight;

    public Rarity(@NotNull CratesPlugin plugin, @NotNull String id, @NotNull String name, double weight) {
        this.plugin = plugin;
        this.id = id.toLowerCase();
        this.setName(name);
        this.setWeight(weight);
    }

    @NotNull
    public static Rarity read(@NotNull CratesPlugin plugin, @NotNull FileConfig config, @NotNull String path, @NotNull String id) {
        String name = config.getString(path + ".Name", StringUtil.capitalizeUnderscored((String)id));
        double weight = config.getDouble(path + ".Weight", config.getDouble(path + ".Chance", 0.0));
        return new Rarity(plugin, id, name, weight);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Name", (Object)this.name);
        config.set(path + ".Weight", (Object)this.weight);
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return Placeholders.RARITY.replacer((Object)this);
    }

    public double getRollChance() {
        return this.getRollChance(this.plugin.getCrateManager().getRarities());
    }

    public double getRollChance(@NotNull Crate crate) {
        return this.getRollChance(crate.getRarities());
    }

    public double getRollChance(@NotNull Collection<Rarity> rarities) {
        double sum = rarities.stream().mapToDouble(Rarity::getWeight).sum();
        return this.getWeight() / sum * 100.0;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getNameTranslated() {
        return NightMessage.asLegacy((String)this.getName());
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }
}

