/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.user;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.currency.CurrencyRegistry;
import su.nightexpress.coinsengine.data.DataHandler;
import su.nightexpress.coinsengine.data.DataQueries;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.data.impl.CurrencySettings;
import su.nightexpress.coinsengine.user.UserBalance;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.db.AbstractUserDataManager;
import su.nightexpress.nightcore.db.AbstractUserManager;

public class UserManager
extends AbstractUserManager<CoinsEnginePlugin, CoinsUser> {
    private final DataHandler dataHandler;
    private final CurrencyRegistry registry;

    public UserManager(@NotNull CoinsEnginePlugin plugin, @NotNull CurrencyRegistry registry, @NotNull DataHandler dataHandler) {
        super((NightPlugin)plugin, (AbstractUserDataManager)dataHandler);
        this.dataHandler = dataHandler;
        this.registry = registry;
    }

    protected void onLoad() {
        super.onLoad();
        this.dataHandler.addTableSync(this.dataHandler.getUsersTable(), resultSet -> {
            CoinsUser user = DataQueries.USER_LOADER.apply((ResultSet)resultSet);
            this.handleSynchronization(user);
        });
    }

    @NotNull
    public CoinsUser create(@NotNull UUID uuid, @NotNull String name) {
        long dateCreated = System.currentTimeMillis();
        UserBalance balance = new UserBalance();
        this.registry.getCurrencies().forEach(currency -> balance.set((Currency)currency, currency.getStartValue()));
        HashMap<String, CurrencySettings> settingsMap = new HashMap<String, CurrencySettings>();
        boolean hiddenFromTops = false;
        return new CoinsUser(uuid, name, dateCreated, dateCreated, balance, settingsMap, hiddenFromTops);
    }

    public void handleSynchronization(@NotNull CoinsUser fresh) {
        CoinsUser user = (CoinsUser)this.getLoaded(fresh.getId());
        if (user == null) {
            return;
        }
        for (Currency currency : this.registry.getCurrencies()) {
            if (!currency.isSynchronizable()) continue;
            double balance = fresh.getBalance(currency);
            user.getBalance().set(currency, balance);
        }
    }
}

