/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.tops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.config.Perms;
import su.nightexpress.coinsengine.currency.CurrencyRegistry;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.tops.TopEntry;
import su.nightexpress.coinsengine.tops.TopsListener;
import su.nightexpress.coinsengine.tops.command.TopCommandProvider;
import su.nightexpress.coinsengine.tops.menu.TopMenu;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.NumberUtil;

public class TopManager
extends AbstractManager<CoinsEnginePlugin> {
    private final CurrencyRegistry currencyRegistry;
    private final Map<String, Map<String, TopEntry>> topEntries;
    private TopMenu topMenu;

    public TopManager(@NotNull CoinsEnginePlugin plugin, @NotNull CurrencyRegistry currencyRegistry) {
        super((NightCorePlugin)plugin);
        this.currencyRegistry = currencyRegistry;
        this.topEntries = new ConcurrentHashMap<String, Map<String, TopEntry>>();
    }

    protected void onLoad() {
        if (((Boolean)Config.TOPS_USE_GUI.get()).booleanValue()) {
            this.topMenu = (TopMenu)this.addMenu((Menu)new TopMenu((CoinsEnginePlugin)this.plugin, this), "/menu/", "leaderboard.yml");
        }
        ((CoinsEnginePlugin)this.plugin).getCommander().getCurrencyCommands().registerProvider(new TopCommandProvider((CoinsEnginePlugin)this.plugin, this));
        this.addListener((SimpeListener)new TopsListener((CoinsEnginePlugin)this.plugin, this));
        this.addAsyncTask(this::updateBalances, (Integer)Config.TOPS_UPDATE_INTERVAL.get());
    }

    protected void onShutdown() {
        this.topEntries.clear();
    }

    public void updateBalances() {
        this.topEntries.clear();
        List users = ((CoinsEnginePlugin)this.plugin).getDataHandler().getUsers();
        users.removeIf(user -> {
            Player player = user.getPlayer();
            if (player != null) {
                this.hideFromTops(player);
            }
            return user.isHiddenFromTops();
        });
        this.currencyRegistry.getCurrencies().forEach(currency -> {
            AtomicInteger counter = new AtomicInteger(0);
            LinkedHashMap entries = new LinkedHashMap();
            users.stream().sorted(Comparator.comparingDouble(user -> user.getBalance((Currency)currency)).reversed()).forEach(user -> entries.put(LowerCase.INTERNAL.apply(user.getName()), new TopEntry(counter.incrementAndGet(), user.getName(), user.getId(), user.getBalance((Currency)currency))));
            this.topEntries.put(currency.getId(), entries);
        });
    }

    public void hideFromTops(@NotNull Player player) {
        CoinsUser user = (CoinsUser)((CoinsEnginePlugin)this.plugin).getUserManager().getOrFetch(player);
        user.setHiddenFromTops(player.hasPermission((Permission)Perms.HIDE_FROM_TOPS));
    }

    public boolean showLeaderboard(@NotNull CommandSender sender, @NotNull Currency currency, int page) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.topMenu != null) {
                this.topMenu.open(player, currency);
                return true;
            }
        }
        int perPage = (Integer)Config.TOPS_ENTRIES_PER_PAGE.get();
        List<TopEntry> full = this.getTopEntries(currency);
        List split = Lists.split(full, (int)perPage);
        int pages = split.size();
        int index = Math.max(0, Math.min(pages, page) - 1);
        int realPage = index + 1;
        List entries = pages > 0 ? (List)split.get(index) : new ArrayList();
        boolean hasNextPage = realPage < pages;
        boolean hasPrevPage = index > 0;
        currency.sendPrefixed(Lang.TOP_LIST, sender, replacer -> replacer.replace("%next_page%", () -> (hasNextPage ? Lang.TOP_LIST_NEXT_PAGE_ACTIVE : Lang.TOP_LIST_NEXT_PAGE_INACTIVE).text().replace("%value%", String.valueOf(realPage + 1))).replace("%previous_page%", () -> (hasPrevPage ? Lang.TOP_LIST_PREVIOUS_PAGE_ACTIVE : Lang.TOP_LIST_PREVIOUS_PAGE_INACTIVE).text().replace("%value%", String.valueOf(realPage - 1))).replace(currency.replacePlaceholders()).replace("%current%", (Object)realPage).replace("%max%", (Object)pages).replace("%entry%", list -> {
            for (TopEntry entry : entries) {
                list.add(Lang.TOP_ENTRY.text().replace("%pos%", NumberUtil.format((double)entry.getPosition())).replace("%balance%", currency.format(entry.getBalance())).replace("%player_name%", entry.getName()));
            }
        }));
        return true;
    }

    @NotNull
    public Map<String, Map<String, TopEntry>> getTopEntriesMap() {
        return this.topEntries;
    }

    @NotNull
    public List<TopEntry> getTopEntries(@NotNull Currency currency) {
        return new ArrayList<TopEntry>(this.topEntries.getOrDefault(currency.getId(), Collections.emptyMap()).values());
    }

    @Nullable
    public TopEntry getTopEntry(@NotNull Currency currency, @NotNull String name) {
        return (TopEntry)this.topEntries.getOrDefault(currency.getId(), Collections.emptyMap()).get(LowerCase.INTERNAL.apply(name));
    }

    public double getTotalBalance(@NotNull Currency currency) {
        return this.getTopEntries(currency).stream().mapToDouble(TopEntry::getBalance).sum();
    }
}

