/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.migration.impl;

import java.util.HashMap;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.migration.Migrator;

public class VaultMigrator
extends Migrator {
    private final Economy economy;

    public VaultMigrator(@NotNull CoinsEnginePlugin plugin, @NotNull Economy economy) {
        super(plugin, "Vault");
        this.economy = economy;
    }

    @Override
    public boolean canMigrate(@NotNull Currency currency) {
        return !currency.isPrimary();
    }

    @Override
    @NotNull
    public Map<OfflinePlayer, Double> getBalances(@NotNull Currency currency) {
        HashMap<OfflinePlayer, Double> balances = new HashMap<OfflinePlayer, Double>();
        for (OfflinePlayer offlinePlayer : this.plugin.getServer().getOfflinePlayers()) {
            try {
                balances.put(offlinePlayer, this.economy.getBalance(offlinePlayer));
            }
            catch (Exception exception) {
                this.plugin.error("Could not convert Vault <-> Economy balance for '" + String.valueOf(offlinePlayer.getUniqueId()) + "'! See stacktrace for details:");
                exception.printStackTrace();
            }
        }
        return balances;
    }
}

